package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;

import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.LevelPlayInterstitialListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

public class Yodo1MasIronSourceMaxInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private final LevelPlayInterstitialListener interstitialListener = new LevelPlayInterstitialListener() {
        @Override
        public void onAdReady(AdInfo adInfo) {
            String message = "method: onAdReady";
            Yodo1MasLog.d(TAG, message);
            callbackLoad(null);
        }

        @Override
        public void onAdLoadFailed(IronSourceError ironSourceError) {
            String message = "method: onAdLoadFailed, errorCode:  " + ironSourceError.getErrorCode() + " errorMessage: " + ironSourceError.getErrorMessage();
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), null);
        }

        @Override
        public void onAdOpened(AdInfo adInfo) {
            String message = "method: onAdOpened";
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdShowSucceeded(AdInfo adInfo) {
            String message = "method: onAdShowSucceeded";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdShowFailed(IronSourceError ironSourceError, AdInfo adInfo) {
            String message = "method: onAdShowFailed, errorCode: " + ironSourceError.getErrorCode() + " errorMessage: " + ironSourceError.getErrorMessage();
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), null);
        }

        @Override
        public void onAdClicked(AdInfo adInfo) {
            String message = "method: onAdClicked";
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }

        @Override
        public void onAdClosed(AdInfo adInfo) {
            String message = "method: onAdClosed";
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }
    };

    public Yodo1MasIronSourceMaxInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
        IronSource.setLevelPlayInterstitialListener(interstitialListener);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return IronSource.isInterstitialReady();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d(TAG, message);
        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        IronSource.loadInterstitial();
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);

            if (!TextUtils.isEmpty(placement)) {
                IronSource.showInterstitial(placement);
            } else {
                IronSource.showInterstitial();
            }
        }
    }
}
