package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.impressionData.ImpressionData;
import com.ironsource.mediationsdk.impressionData.ImpressionDataListener;
import com.ironsource.mediationsdk.integration.IntegrationHelper;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.LevelPlayRewardedVideoManualListener;
import com.yodo1.mas.analytics.Yodo1MasDataAnalytics;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasIronSourceMaxAdapter extends Yodo1MasAdapterBase {

    private Yodo1MasIronSourceMaxRewardAdapter rewardAdapter;
    private final LevelPlayRewardedVideoManualListener rewardedVideoManualListener = new LevelPlayRewardedVideoManualListener() {
        @Override
        public void onAdOpened(AdInfo adInfo) {
            if (rewardAdapter != null) {
                rewardAdapter.onAdOpened(adInfo);
            }
        }

        @Override
        public void onAdShowFailed(IronSourceError ironSourceError, AdInfo adInfo) {
            if (rewardAdapter != null) {
                rewardAdapter.onAdShowFailed(ironSourceError, adInfo);
            }
        }

        @Override
        public void onAdClicked(Placement placement, AdInfo adInfo) {
            if (rewardAdapter != null) {
                rewardAdapter.onAdClicked(placement, adInfo);
            }
        }

        @Override
        public void onAdRewarded(Placement placement, AdInfo adInfo) {
            if (rewardAdapter != null) {
                rewardAdapter.onAdRewarded(placement, adInfo);
            }
        }

        @Override
        public void onAdClosed(AdInfo adInfo) {
            if (rewardAdapter != null) {
                rewardAdapter.onAdClosed(adInfo);
            }
        }

        @Override
        public void onAdReady(AdInfo adInfo) {
            if (rewardAdapter != null) {
                rewardAdapter.onAdReady(adInfo);
            }
        }

        @Override
        public void onAdLoadFailed(IronSourceError ironSourceError) {
            if (rewardAdapter != null) {
                rewardAdapter.onAdLoadFailed(ironSourceError);
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return "IRONSOURCE";
    }

    @Override
    public String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public boolean isMax() {
        return true;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!isInitSDK()) {
            if (Yodo1MasHelper.getInstance().isDebug()) {
                IronSource.setLogListener((tag, msg, i) -> {

                });
                IronSource.setAdaptersDebug(true);
            }
            if (TextUtils.isEmpty(config.appId)) {
                if (callback != null) {
                    callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, "config.appId is null"));
                }
                return;
            }

            init = true;
            IronSource.setLevelPlayRewardedVideoManualListener(rewardedVideoManualListener);
            IronSource.addImpressionDataListener(new ImpressionDataListener() {
                @Override
                public void onImpressionSuccess(ImpressionData impressionData) {
//                    Yodo1MasDataAnalytics.trackAdRevenue("ironSource",
//                            impressionData.getAdNetwork(),
//                            impressionData.getAdUnit(),
//                            impressionData.getInstanceName(),
//                            impressionData.getRevenue(), "USD");
                }
            });
            updatePrivacy();

            IronSource.init(activity, config.appId, IronSource.AD_UNIT.REWARDED_VIDEO, IronSource.AD_UNIT.INTERSTITIAL, IronSource.AD_UNIT.BANNER);
            IntegrationHelper.validateIntegration(activity);

            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
        } else {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
        }
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        IronSource.setConsent(Yodo1MasHelper.getInstance().isGDPRUserConsent());
        IronSource.setMetaData("do_not_sell", Boolean.toString(Yodo1MasHelper.getInstance().isCCPADoNotSell()));

        /*
         * Google Play Families compliance, you can find out details from the below link
         * https://developers.is.com/ironsource-mobile/android/regulation-advanced-settings/#step-4
         */
        // Apps directed at a mixed audience
        boolean isAgeRestricted = Yodo1MasHelper.getInstance().isCOPPAAgeRestricted();
        IronSource.setMetaData("is_child_directed", Boolean.toString(isAgeRestricted));
        IronSource.setMetaData("is_deviceid_optout", Boolean.toString(isAgeRestricted));

        boolean isChild = Yodo1MasHelper.getInstance().isCOPPAAgeRestricted();
        String isChildBoolean = isChild ? "true" : "false";

        /**
         * https://developers.is.com/ironsource-mobile/android/admob-mediation-guide/#step-6
         */
        IronSource.setMetaData("AdMob_TFCD", isChildBoolean);
        IronSource.setMetaData("AdMob_TFUA", isChildBoolean);

        /**
         * https://developers.is.com/ironsource-mobile/android/applovin-mediation-guide/#step-7
         */
        IronSource.setMetaData("AppLovin_AgeRestrictedUser", isChildBoolean);

        /**
         * facebook
         * https://developers.is.com/ironsource-mobile/android/facebook-mediation-guide/#step-11
         */
        if (isChild) {
            IronSource.setMetaData("META_Mixed_Audience", isChildBoolean);
        }

        /**
         * fyber
         * https://developers.is.com/ironsource-mobile/android/fyber-mediation-integration-guide/#step-5
         */
        if (isChild) {
            IronSource.setMetaData("DT_IsChild", isChildBoolean);
        }

        /**
         * https://developers.is.com/ironsource-mobile/android/inmobi-mediation-guide/#step-6
         */
        IronSource.setMetaData("InMobi_AgeRestricted", isChildBoolean);

        /**
         * https://developers.is.com/ironsource-mobile/android/mintegral-integration-guide/#step-6
         */
        IronSource.setMetaData("Mintegral_COPPA", isChildBoolean);

        /**
         * https://developers.is.com/ironsource-mobile/android/pangle-integration-guide/#step-6
         */
        String isChildInt = isChild ? "1" : "0";
        IronSource.setMetaData("Pangle_COPPA", isChildInt);

        /*
         * UnityAds Families compliance, https://developers.is.com/ironsource-mobile/android/unityads-mediation-guide/#step-6
         */
        IronSource.setMetaData("UnityAds_coppa", isChildBoolean);

        /**
         * Liftoff Monetize (previously Vungle)
         * https://developers.is.com/ironsource-mobile/android/liftoff-monetize-mediation-guide/#step-6
         */
        IronSource.setMetaData("Vungle_coppa", isChildBoolean);
    }

    @Override
    public void onActivityResume(@NonNull Activity activity) {
        super.onActivityResume(activity);
        if (!isInitSDK()) return;
        IronSource.onResume(activity);
    }

    @Override
    public void onActivityPause(@NonNull Activity activity) {
        super.onActivityPause(activity);
        if (!isInitSDK()) return;
        IronSource.onPause(activity);
    }

    // Reward
    @Override
    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasIronSourceMaxRewardAdapter.class;
    }

    @Override
    public Yodo1MasRewardAdapterBase getRewardAdapter(AdId rewardAdId) {
        Yodo1MasIronSourceMaxRewardAdapter adapter = (Yodo1MasIronSourceMaxRewardAdapter) super.getRewardAdapter(rewardAdId);
        rewardAdapter = adapter;
        return adapter;
    }

    // Interstitial
    @Override
    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasIronSourceMaxInterstitialAdapter.class;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasIronSourceMaxBannerAdapter.class;
    }

    // Rewarded Interstitial
    @Override
    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    // App Open
    @Override
    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}
