package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.LevelPlayRewardedVideoManualListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

public class Yodo1MasIronSourceMaxRewardAdapter extends Yodo1MasRewardAdapterBase implements LevelPlayRewardedVideoManualListener {

    private boolean isRewarded = false;

    public Yodo1MasIronSourceMaxRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
//        IronSource.setManualLoadRewardedVideo(rewardedListener);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return IronSource.isRewardedVideoAvailable();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d(TAG, message);
        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        IronSource.loadRewardedVideo();
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, loading reward ad...";
            Yodo1MasLog.d(TAG, message);

            if (!TextUtils.isEmpty(placement)) {
                IronSource.showRewardedVideo(placement);
            } else {
                IronSource.showRewardedVideo();
            }
        }
    }

    @Override
    public void onAdReady(AdInfo adInfo) {
        String message = "method: onAdReady";
        Yodo1MasLog.d(TAG, message);
        callbackLoad(null);
    }

    @Override
    public void onAdLoadFailed(IronSourceError ironSourceError) {
        String message = "method: onAdLoadFailed, errorCode: " + ironSourceError.getErrorCode() + " errorMessage: " + ironSourceError.getErrorMessage();
        Yodo1MasLog.d(TAG, message);
        Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
        callbackError(error, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), null);
    }

    @Override
    public void onAdOpened(AdInfo adInfo) {
        String message = "method: onAdOpened";
        Yodo1MasLog.d(TAG, message);
        callbackOpen();
    }

    @Override
    public void onAdShowFailed(IronSourceError ironSourceError, AdInfo adInfo) {
        String message = "method: onAdShowFailed, errorCode: " + ironSourceError.getErrorCode() + " errorMessage: " + ironSourceError.getErrorMessage();
        Yodo1MasLog.d(TAG, message);
        Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
        callbackError(error, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), null);
    }

    @Override
    public void onAdClicked(Placement placement, AdInfo adInfo) {
        String message = "method: onAdClicked, placement: " + placement.getPlacementName();
        Yodo1MasLog.d(TAG, message);
        callbackClick();
    }

    @Override
    public void onAdRewarded(Placement placement, AdInfo adInfo) {
        String message = "method: onAdRewarded, placement: " + placement.getPlacementName();
        Yodo1MasLog.d(TAG, message);
        isRewarded = true;
    }

    @Override
    public void onAdClosed(AdInfo adInfo) {
        String message = "method: onAdClosed";
        Yodo1MasLog.d(TAG, message);
        if (isRewarded) {
            callbackEarned();
            isRewarded = false;
        }
        callbackClose();
    }
}
