package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;

import androidx.annotation.NonNull;

import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.LevelPlayBannerListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasIronSourceBannerAdapter extends Yodo1MasBannerAdapterBase {

    private final LevelPlayBannerListener bannerListener = new LevelPlayBannerListener() {
        @Override
        public void onAdLoaded(AdInfo adInfo) {
            String message = "method: onAdLoaded";
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            trackAdRequestSuccessed();
            callback(Yodo1MasAdEvent.CODE_LOADED, TAG + ":{" + message + "}");

            advertAdapterState = AdvertAdapterState.LOADED;
            callbackAdapterState();
        }

        @Override
        public void onAdLoadFailed(IronSourceError ironSourceError) {
            String message = "method: onAdLoadFailed, errorCode: " + ironSourceError.getErrorCode() + " errorMessage: " + ironSourceError.getErrorMessage();
            Yodo1MasLog.d(TAG, message);
            trackAdRequestFailed(ironSourceError.getErrorCode(), ironSourceError.getErrorMessage());

            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            if (isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
                callback(error);
                advertAdapterState = AdvertAdapterState.FAILED;
                callbackAdapterState();
            } else {
                nextBanner();
                loadBannerAdvertDelayed();
            }
        }

        @Override
        public void onAdClicked(AdInfo adInfo) {
            String message = "method: onAdClicked";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdLeftApplication(AdInfo adInfo) {
            String message = "method: onBannerAdLeftApplication";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdScreenPresented(AdInfo adInfo) {
            String message = "method: onAdScreenPresented";
            Yodo1MasLog.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_OPENED, TAG + ":{" + message + "}");
        }

        @Override
        public void onAdScreenDismissed(AdInfo adInfo) {
            String message = "method: onAdScreenDismissed";
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            callback(Yodo1MasAdEvent.CODE_CLOSED, TAG + ":{" + message + "}");
            loadBannerAdvert();
        }
    };
    private IronSourceBannerLayout bannerAd;

    public Yodo1MasIronSourceBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    @Override
    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        return bannerAd != null && adId != null && !TextUtils.isEmpty(adId.adId) && bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (relateAdapter == null || !relateAdapter.isInitSDK()) {
            return;
        }

        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        if (adId != null && adId.object != null && !isPriceValuable(adId)) {
            handlePricyNotAbaliable();
            return;
        }

        if (adId != null && !TextUtils.isEmpty(adId.adId) && (bannerAd == null || !adId.adId.equals(bannerAd.getPlacementName()))) {
            ISBannerSize bannerSize = getBannerSize();
            bannerAd = new IronSourceBannerLayout(activity, bannerSize);
            bannerAd.setLevelPlayBannerListener(bannerListener);
            bannerAd.setPlacementName(adId.adId);
        }
        if (bannerAd != null && bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Yodo1MasLog.d(TAG, message);
            IronSource.loadBanner(bannerAd);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            advertAdapterState = AdvertAdapterState.LOADING;
            logAdIdInfo(adId);
        }
    }

    private ISBannerSize getBannerSize() {
        Yodo1MasBannerAdSize size = bannerConfig.size;
        Yodo1MasLog.d(TAG, "setBannerSize: size: " + size.name());

        if (Yodo1MasBannerAdSize.Banner == size) {
            return ISBannerSize.BANNER;
        }
//        else if(Yodo1MasBannerAdSize.IABMediumRectangle == size) {
//            return ISBannerSize.RECTANGLE;
//        }
//        else if(Yodo1MasBannerAdSize.SmartBanner == size) {
//            return ISBannerSize.SMART;
//        }

        return ISBannerSize.BANNER;
    }

    @Override
    public View getBannerView() {
        return bannerAd;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                IronSource.destroyBanner(bannerAd);
                bannerAd = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                advertAdapterState = AdvertAdapterState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return false;
    }
}
