package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ironsource.mediationsdk.IronSource;
import com.unity3d.mediation.LevelPlay;
import com.unity3d.mediation.LevelPlayConfiguration;
import com.unity3d.mediation.LevelPlayInitError;
import com.unity3d.mediation.LevelPlayInitListener;
import com.unity3d.mediation.LevelPlayInitRequest;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasIronSourceMaxAdapter extends Yodo1MasAdapterBase {

    @Override
    public String getAdvertCode() {
        return "IRONSOURCE";
    }

    @Override
    public String getSDKVersion() {
        return LevelPlay.getSdkVersion();
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public boolean isMax() {
        return true;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!isInitSDK()) {
            if (Yodo1MasHelper.getInstance().isDebug()) {
                LevelPlay.setMetaData("is_test_suite", "enable");
                LevelPlay.setAdaptersDebug(true);
//                LevelPlay.validateIntegration(activity.getApplicationContext());
            }
            if (TextUtils.isEmpty(config.appId)) {
                if (callback != null) {
                    callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, "config.appId is null"));
                }
                return;
            }

            init = true;
            updatePrivacy();

            LevelPlayInitRequest.Builder builder = new LevelPlayInitRequest.Builder(config.appId);
            String userIdentifier = Yodo1MasHelper.getInstance().getUserIdentifier();
            if(!TextUtils.isEmpty(userIdentifier)) {
                builder.withUserId(userIdentifier);
            }

            LevelPlayInitListener initListener = new LevelPlayInitListener() {

                @Override
                public void onInitSuccess(@NonNull LevelPlayConfiguration levelPlayConfiguration) {
                    String message = "method: onInitializationComplete, init successful";
                    Yodo1MasLog.d(TAG, message);
                    if (callback != null) {
                        callback.onAdapterInitSuccessful(getAdvertCode());
                    }
                }

                @Override
                public void onInitFailed(@NonNull LevelPlayInitError levelPlayInitError) {
                    String message = "method: onInitializationFailed, error: " + levelPlayInitError.getErrorCode() + ", message:" + levelPlayInitError.getErrorMessage();
                    Yodo1MasLog.d(TAG, message);
                    if (callback != null) {
                        callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, message));
                    }
                }
            };
            LevelPlay.init(activity, builder.build(), initListener);
        } else {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
        }
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        LevelPlay.setConsent(Yodo1MasHelper.getInstance().isGDPRUserConsent());
        LevelPlay.setMetaData("do_not_sell", Boolean.toString(Yodo1MasHelper.getInstance().isCCPADoNotSell()));

        /*
         * Google Play Families compliance, you can find out details from the below link
         * https://developers.is.com/ironsource-mobile/android/regulation-advanced-settings/#step-4
         */
        // Apps directed at a mixed audience
        boolean isAgeRestricted = Yodo1MasHelper.getInstance().isCOPPAAgeRestricted();
        LevelPlay.setMetaData("is_child_directed", Boolean.toString(isAgeRestricted));
        LevelPlay.setMetaData("is_deviceid_optout", Boolean.toString(isAgeRestricted));

        boolean isChild = Yodo1MasHelper.getInstance().isCOPPAAgeRestricted();
        String isChildBoolean = isChild ? "true" : "false";

        /**
         * https://developers.is.com/ironsource-mobile/android/admob-mediation-guide/#step-6
         */
        LevelPlay.setMetaData("AdMob_TFCD", isChildBoolean);
        LevelPlay.setMetaData("AdMob_TFUA", isChildBoolean);

        /**
         * https://developers.is.com/ironsource-mobile/android/applovin-mediation-guide/#step-7
         */
        LevelPlay.setMetaData("AppLovin_AgeRestrictedUser", isChildBoolean);

        /**
         * https://developers.is.com/ironsource-mobile/android/bidmachine-integration-guide/#step-5
         */
        LevelPlay.setMetaData("BidMachine_COPPA",isChildBoolean);

        /**
         * https://developers.is.com/ironsource-mobile/android/chartboost-mediation-guide/#step-6
         */
        IronSource.setMetaData("Chartboost_Coppa",isChildBoolean);

        /**
         * facebook
         * https://developers.is.com/ironsource-mobile/android/facebook-mediation-guide/#step-11
         */
        if (isChild) {
            LevelPlay.setMetaData("META_Mixed_Audience", isChildBoolean);
        }

        /**
         * fyber
         * https://developers.is.com/ironsource-mobile/android/fyber-mediation-integration-guide/#step-5
         */
        if (isChild) {
            LevelPlay.setMetaData("DT_IsChild", isChildBoolean);
        }

        /**
         * https://developers.is.com/ironsource-mobile/android/inmobi-mediation-guide/#step-6
         */
        LevelPlay.setMetaData("InMobi_AgeRestricted", isChildBoolean);

        /**
         * https://developers.is.com/ironsource-mobile/android/mintegral-integration-guide/#step-6
         */
        LevelPlay.setMetaData("Mintegral_COPPA", isChildBoolean);

        /**
         * https://developers.is.com/ironsource-mobile/android/moloco-integration-guide/#step-6
         */
        LevelPlay.setMetaData("Moloco_COPPA",isChildBoolean);

        /**
         * https://developers.is.com/ironsource-mobile/android/pangle-integration-guide/#step-6
         */
        String isChildInt = isChild ? "1" : "0";
        LevelPlay.setMetaData("Pangle_COPPA", isChildInt);

        /*
         * UnityAds Families compliance, https://developers.is.com/ironsource-mobile/android/unityads-mediation-guide/#step-6
         */
        LevelPlay.setMetaData("UnityAds_coppa", isChildBoolean);

        /**
         * Liftoff Monetize (previously Vungle)
         * https://developers.is.com/ironsource-mobile/android/liftoff-monetize-mediation-guide/#step-6
         */
        LevelPlay.setMetaData("Vungle_coppa", isChildBoolean);

        /**
         * https://developers.is.com/ironsource-mobile/android/yandex-integration-guide/#step-6
         */
        LevelPlay.setMetaData("Yandex_COPPA",isChildBoolean);
    }

    @Override
    public void onActivityResume(@NonNull Activity activity) {
        super.onActivityResume(activity);
        if (!isInitSDK()) return;
        IronSource.onResume(activity);
    }

    @Override
    public void onActivityPause(@NonNull Activity activity) {
        super.onActivityPause(activity);
        if (!isInitSDK()) return;
        IronSource.onPause(activity);
    }

    // Reward
    @Override
    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasIronSourceMaxRewardAdapter.class;
    }

    @Override
    public Yodo1MasRewardAdapterBase getRewardAdapter(AdId rewardAdId) {
        Yodo1MasIronSourceMaxRewardAdapter adapter = (Yodo1MasIronSourceMaxRewardAdapter) super.getRewardAdapter(rewardAdId);
        return adapter;
    }

    // Interstitial
    @Override
    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasIronSourceMaxInterstitialAdapter.class;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasIronSourceMaxBannerAdapter.class;
    }

    @Override
    public Yodo1MasBannerAdapterBase getBannerAdapter() {
        Yodo1MasIronSourceMaxBannerAdapter bannerAdapter = (Yodo1MasIronSourceMaxBannerAdapter) super.getBannerAdapter();
        bannerAdapter.setMax(isMax());
        return bannerAdapter;
    }

    // Rewarded Interstitial
    @Override
    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    // App Open
    @Override
    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}
