package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;

import androidx.annotation.NonNull;

import com.unity3d.mediation.LevelPlayAdError;
import com.unity3d.mediation.LevelPlayAdInfo;
import com.unity3d.mediation.LevelPlayAdSize;
import com.unity3d.mediation.banner.LevelPlayBannerAdView;
import com.unity3d.mediation.banner.LevelPlayBannerAdViewListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasIronSourceMaxBannerAdapter extends Yodo1MasBannerAdapterBase {

    private LevelPlayBannerAdView bannerAd;

    private final LevelPlayBannerAdViewListener bannerListener = new LevelPlayBannerAdViewListener() {
        @Override
        public void onAdLoaded(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            String message = "method: onAdLoaded, banner, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;

            adSource = levelPlayAdInfo.getAdNetwork();
            price = levelPlayAdInfo.getRevenue() * 1000;

            adNetworkUnitId = levelPlayAdInfo.getAdUnitId();
            adSourceUnitId = levelPlayAdInfo.getInstanceId();
            revenue = levelPlayAdInfo.getRevenue();
            revenuePrecision = TextUtils.equals("BID",levelPlayAdInfo.getPrecision()) ? "exact" : "publisher_defined";

            trackAdRequestSuccessed();
            callback(Yodo1MasAdEvent.CODE_LOADED, TAG + ":{" + message + "}");
            advertAdapterState = AdvertAdapterState.LOADED;
            callbackAdapterState();
        }

        @Override
        public void onAdLoadFailed(@NonNull LevelPlayAdError levelPlayAdError) {
            String message = "method: onAdLoadFailed, banner, AdUnitId: " + levelPlayAdError.getAdUnitId() + ", errorCode: " + levelPlayAdError.getErrorCode() + " errorMessage: " + levelPlayAdError.getErrorMessage();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            revenue = 0;
            adSource = "";
            trackAdRequestFailed(levelPlayAdError.getErrorCode(), levelPlayAdError.getErrorMessage());

            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            if (isMax()) {
                handleLoadFailedCallback(message);
                nextBanner();
                loadBannerAdvertDelayed();
            } else if (isLastPlacement()) {
                handleLoadFailedCallback(message);
            } else {
                nextBanner();
                loadBannerAdvertDelayed();
            }
        }

        @Override
        public void onAdDisplayed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            LevelPlayBannerAdViewListener.super.onAdDisplayed(levelPlayAdInfo);
            String message = "method: onAdDisplayed, banner, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            callback(Yodo1MasAdEvent.CODE_OPENED, TAG + ":{" + message + "}");
        }

        @Override
        public void onAdDisplayFailed(@NonNull LevelPlayAdInfo levelPlayAdInfo, @NonNull LevelPlayAdError levelPlayAdError) {
            LevelPlayBannerAdViewListener.super.onAdDisplayFailed(levelPlayAdInfo, levelPlayAdError);
            String message = "method: onAdDisplayFailed, banner, AdUnitId: " + levelPlayAdError.getAdUnitId() + ", errorCode: " + levelPlayAdError.getErrorCode() + " errorMessage: " + levelPlayAdError.getErrorMessage();
            Yodo1MasLog.d(TAG, message);

//            price = 0;
//            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
//            callbackDisplayError(error, levelPlayAdError.getErrorCode(), levelPlayAdError.getErrorMessage());
//            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
//
//            advertAdapterState = AdvertAdapterState.FAILED;
//            if (isMax()) {
//                handleLoadFailedCallback(message);
//                nextBanner();
//                loadBannerAdvertDelayed();
//            } else if (isLastPlacement()) {
//                handleLoadFailedCallback(message);
//            } else {
//                nextBanner();
//                loadBannerAdvertDelayed();
//            }
        }

        @Override
        public void onAdClicked(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            LevelPlayBannerAdViewListener.super.onAdClicked(levelPlayAdInfo);
            String message = "method: onAdClicked, banner, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", error: " + levelPlayAdInfo.getAdUnitId();
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdExpanded(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            LevelPlayBannerAdViewListener.super.onAdExpanded(levelPlayAdInfo);
        }

        @Override
        public void onAdLeftApplication(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            LevelPlayBannerAdViewListener.super.onAdLeftApplication(levelPlayAdInfo);
        }

        @Override
        public void onAdCollapsed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            LevelPlayBannerAdViewListener.super.onAdCollapsed(levelPlayAdInfo);
        }
    };

    public Yodo1MasIronSourceMaxBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    @Override
    public boolean isMax() {
        return isMax;
    }

    public void setMax(boolean max) {
        isMax = max;
    }

    @Override
    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return bannerAd != null && bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (relateAdapter != null && !relateAdapter.isInitSDK()) {
            return;
        }

        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        if (!isMax() && adId != null && adId.object != null && !isPriceValuable(adId)) {
            handlePricyNotAbaliable();
            return;
        }

        if (adId != null && !TextUtils.isEmpty(adId.adId)) {
            if (bannerAd == null) {
                LevelPlayAdSize adSize = getBannerSize(activity.getApplicationContext());
                LevelPlayBannerAdView.Config.Builder builder = new LevelPlayBannerAdView.Config.Builder();
                builder.setAdSize(adSize);
                if (!TextUtils.isEmpty(placement)) {
                    builder.setPlacementName(placement);
                }
                bannerAd = new LevelPlayBannerAdView(activity, adId.adId, builder.build());
            }
            if (bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
                String message = "method: loadBannerAdvert, loading banner ad...";
                Yodo1MasLog.d(TAG, message);

                bannerAd.setBannerListener(bannerListener);
                bannerAd.loadAd();
                bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
                advertAdapterState = AdvertAdapterState.LOADING;
            }
        }
    }

    private LevelPlayAdSize getBannerSize(Context context) {
        Yodo1MasBannerAdSize size = bannerConfig.size;
        Yodo1MasLog.d(TAG, "setBannerSize: size: " + size.name());
        LevelPlayAdSize bannerSize = LevelPlayAdSize.BANNER;
        if (Yodo1MasBannerAdSize.LargeBanner == size) {
            bannerSize = LevelPlayAdSize.LARGE;
        } else if (Yodo1MasBannerAdSize.IABMediumRectangle == size) {
            bannerSize = LevelPlayAdSize.MEDIUM_RECTANGLE;
        } else if (Yodo1MasBannerAdSize.AdaptiveBanner == size) {
            bannerSize = LevelPlayAdSize.createAdaptiveAdSize(context);
        }
        return bannerSize;
    }

    @Override
    public View getBannerView() {
        return bannerAd;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                bannerAd.destroy();
                bannerAd = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                advertAdapterState = AdvertAdapterState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return super.isSupportMultipleInstance();
    }

    private void handleLoadFailedCallback(String message) {
        Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
        callback(error);
        advertAdapterState = AdvertAdapterState.FAILED;
        callbackAdapterState();
    }
}
