package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.unity3d.mediation.LevelPlayAdError;
import com.unity3d.mediation.LevelPlayAdInfo;
import com.unity3d.mediation.interstitial.LevelPlayInterstitialAd;
import com.unity3d.mediation.interstitial.LevelPlayInterstitialAdListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasIronSourceMaxInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {
    private LevelPlayInterstitialAd interstitialAd;
    private final LevelPlayInterstitialAdListener adListener = new LevelPlayInterstitialAdListener() {
        @Override
        public void onAdLoaded(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            String message = "method: onAdLoaded, interstitial, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d(TAG, message);
            adSource = levelPlayAdInfo.getAdNetwork();
            price = levelPlayAdInfo.getRevenue() * 1000;

            adNetworkUnitId = levelPlayAdInfo.getAdUnitId();
            adSourceUnitId = levelPlayAdInfo.getInstanceId();
            revenue = levelPlayAdInfo.getRevenue();
            revenuePrecision = TextUtils.equals("BID",levelPlayAdInfo.getPrecision()) ? "exact" : "publisher_defined";

            adRequestResult = Yodo1MasAdRequestTrackUtil.getMediationAdRequestResult(Yodo1Mas.AdType.Interstitial, advertCode, adSource, adNetworkUnitId, true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onAdLoadFailed(@NonNull LevelPlayAdError levelPlayAdError) {
            String message = "method: onAdLoadFailed, interstitial, AdUnitId: " + levelPlayAdError.getAdUnitId() + ", errorCode: " + levelPlayAdError.getErrorCode() + " errorMessage: " + levelPlayAdError.getErrorMessage();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            adRequestResult = Yodo1MasAdRequestTrackUtil.getMediationAdRequestResult(Yodo1Mas.AdType.Interstitial, advertCode, adSource, getAdUnitId(), false, getAdLoadDuration(), levelPlayAdError.getErrorCode() + "", levelPlayAdError.getErrorMessage());
            callbackError(error, levelPlayAdError.getErrorCode(), levelPlayAdError.getErrorMessage(), adRequestResult);
        }

        @Override
        public void onAdDisplayed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            String message = "method: onAdDisplayed, interstitial, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdDisplayFailed(@NonNull LevelPlayAdError levelPlayAdError, @NonNull LevelPlayAdInfo levelPlayAdInfo) {
            LevelPlayInterstitialAdListener.super.onAdDisplayFailed(levelPlayAdError, levelPlayAdInfo);
            String message = "method: onAdDisplayFailed, interstitial, AdUnitId: " + levelPlayAdError.getAdUnitId() + ", errorCode: " + levelPlayAdError.getErrorCode() + " errorMessage: " + levelPlayAdError.getErrorMessage();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, levelPlayAdError.getErrorCode(), levelPlayAdError.getErrorMessage(), null);
        }

        @Override
        public void onAdClicked(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            LevelPlayInterstitialAdListener.super.onAdClicked(levelPlayAdInfo);
            Yodo1MasLog.d(TAG, "onAdClicked: ");
            callbackClick();
        }

        @Override
        public void onAdClosed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            LevelPlayInterstitialAdListener.super.onAdClosed(levelPlayAdInfo);
            String message = "method: onAdClosed, interstitial, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            revenue = 0;
            callbackClose();
        }
    };

    public Yodo1MasIronSourceMaxInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && interstitialAd.isAdReady();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (!isNetworkInited()) {
            String message = "method: loadInterstitialAdvert, the IRONSOURCE mediation sdk has not been initialized yet ";
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            String tdErrorMsg = "Yodo1Mas IRONSOURCE mediation error: the ironsource mediation sdk has not been initialized yet";
            adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial, advertCode, getAdUnitId(), false, 0, null, tdErrorMsg);
            callbackError(error, 0, tdErrorMsg, adRequestResult);
            return;
        }

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d(TAG, message);
        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();

        interstitialAd = new LevelPlayInterstitialAd(adId);
        interstitialAd.setListener(adListener);
        interstitialAd.loadAd();
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);

            if (!TextUtils.isEmpty(placement)) {
                interstitialAd.showAd(activity, placement);
            } else {
                interstitialAd.showAd(activity);
            }
        }
    }
}
