package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;

import com.unity3d.mediation.LevelPlayAdError;
import com.unity3d.mediation.LevelPlayAdInfo;
import com.unity3d.mediation.rewarded.LevelPlayReward;
import com.unity3d.mediation.rewarded.LevelPlayRewardedAd;
import com.unity3d.mediation.rewarded.LevelPlayRewardedAdListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasIronSourceMaxRewardAdapter extends Yodo1MasRewardAdapterBase {
    private LevelPlayRewardedAd rewardedAd;

    private final LevelPlayRewardedAdListener adListener = new LevelPlayRewardedAdListener() {
        @Override
        public void onAdLoaded(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            String message = "method: onAdLoaded, reward, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d(TAG, message);
            adSource = levelPlayAdInfo.getAdNetwork();
            price = levelPlayAdInfo.getRevenue() * 1000;

            adNetworkUnitId = levelPlayAdInfo.getAdUnitId();
            adSourceUnitId = levelPlayAdInfo.getInstanceId();
            revenue = levelPlayAdInfo.getRevenue();
            revenuePrecision = TextUtils.equals("BID",levelPlayAdInfo.getPrecision()) ? "exact" : "publisher_defined";

            adRequestResult = Yodo1MasAdRequestTrackUtil.getMediationAdRequestResult(Yodo1Mas.AdType.Reward, advertCode, adSource, adNetworkUnitId, true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onAdLoadFailed(@NonNull LevelPlayAdError levelPlayAdError) {
            String message = "method: onAdLoadFailed, reward, AdUnitId: " + levelPlayAdError.getAdUnitId() + ", errorCode: " + levelPlayAdError.getErrorCode() + " errorMessage: " + levelPlayAdError.getErrorMessage();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            adRequestResult = Yodo1MasAdRequestTrackUtil.getMediationAdRequestResult(Yodo1Mas.AdType.Reward, advertCode, adSource, getAdUnitId(), false, getAdLoadDuration(), levelPlayAdError.getErrorCode() + "", levelPlayAdError.getErrorMessage());
            callbackError(error, levelPlayAdError.getErrorCode(), levelPlayAdError.getErrorMessage(), adRequestResult);
        }

        @Override
        public void onAdDisplayed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            String message = "method: onAdDisplayed, reward, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdDisplayFailed(@NonNull LevelPlayAdError levelPlayAdError, @NonNull LevelPlayAdInfo levelPlayAdInfo) {
            LevelPlayRewardedAdListener.super.onAdDisplayFailed(levelPlayAdError, levelPlayAdInfo);
            String message = "method: onAdDisplayFailed, reward, AdUnitId: " + levelPlayAdError.getAdUnitId() + ", errorCode: " + levelPlayAdError.getErrorCode() + " errorMessage: " + levelPlayAdError.getErrorMessage();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, levelPlayAdError.getErrorCode(), levelPlayAdError.getErrorMessage(), null);
        }

        @Override
        public void onAdClicked(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            LevelPlayRewardedAdListener.super.onAdClicked(levelPlayAdInfo);
            Yodo1MasLog.d(TAG, "onAdClicked: ");
            callbackClick();
        }

        @Override
        public void onAdClosed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            LevelPlayRewardedAdListener.super.onAdClosed(levelPlayAdInfo);
            String message = "method: onAdClosed, reward, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            revenue = 0;
            callbackClose();
        }

        @Override
        public void onAdRewarded(@NonNull LevelPlayReward levelPlayReward, @NonNull LevelPlayAdInfo levelPlayAdInfo) {
            String message = "method: onAdRewarded, reward, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d(TAG, message);
            callbackEarned();
        }
    };

    public Yodo1MasIronSourceMaxRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardedAd != null && rewardedAd.isAdReady();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (!isNetworkInited()) {
            String message = "method: loadRewardAdvert, the IRONSOURCE mediation sdk has not been initialized yet ";
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            String tdErrorMsg = "Yodo1Mas IRONSOURCE mediation error: the ironsource mediation sdk has not been initialized yet";
            adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward, advertCode, getAdUnitId(), false, 0, null, tdErrorMsg);
            callbackError(error, 0, tdErrorMsg, adRequestResult);
            return;
        }

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d(TAG, message);
        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();

        rewardedAd = new LevelPlayRewardedAd(adId);
        rewardedAd.setListener(adListener);
        rewardedAd.loadAd();
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d(TAG, message);

            if (TextUtils.isEmpty(placement)) {
                rewardedAd.showAd(activity);
            } else {
                rewardedAd.showAd(activity, placement);
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }
}
