/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ironsource.mediationsdk.IronSource;
import com.unity3d.mediation.LevelPlay;
import com.unity3d.mediation.LevelPlayConfiguration;
import com.unity3d.mediation.LevelPlayInitError;
import com.unity3d.mediation.LevelPlayInitListener;
import com.unity3d.mediation.LevelPlayInitRequest;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.ironsource.Yodo1MasIronSourceMaxBannerAdapter;
import com.yodo1.mas.mediation.ironsource.Yodo1MasIronSourceMaxInterstitialAdapter;
import com.yodo1.mas.mediation.ironsource.Yodo1MasIronSourceMaxRewardAdapter;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasIronSourceMaxAdapter
extends Yodo1MasAdapterBase {
    public String getAdvertCode() {
        return "IRONSOURCE";
    }

    public String getSDKVersion() {
        return LevelPlay.getSdkVersion();
    }

    public String getMediationVersion() {
        return "4.17.1";
    }

    public boolean isMax() {
        return true;
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, final @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            if (Yodo1MasHelper.getInstance().isDebug()) {
                LevelPlay.setMetaData((String)"is_test_suite", (String)"enable");
                LevelPlay.setAdaptersDebug((boolean)true);
            }
            if (TextUtils.isEmpty((CharSequence)config.appId)) {
                if (callback != null) {
                    callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
                }
                return;
            }
            this.init = true;
            this.updatePrivacy();
            LevelPlayInitRequest.Builder builder = new LevelPlayInitRequest.Builder(config.appId);
            String userIdentifier = Yodo1MasHelper.getInstance().getUserIdentifier();
            if (!TextUtils.isEmpty((CharSequence)userIdentifier)) {
                builder.withUserId(userIdentifier);
            }
            LevelPlayInitListener initListener = new LevelPlayInitListener(){

                public void onInitSuccess(@NonNull LevelPlayConfiguration levelPlayConfiguration) {
                    String message = "method: onInitializationComplete, init successful";
                    Yodo1MasLog.d((String)Yodo1MasIronSourceMaxAdapter.this.TAG, (String)message);
                    if (callback != null) {
                        callback.onAdapterInitSuccessful(Yodo1MasIronSourceMaxAdapter.this.getAdvertCode());
                    }
                }

                public void onInitFailed(@NonNull LevelPlayInitError levelPlayInitError) {
                    String message = "method: onInitializationFailed, error: " + levelPlayInitError.getErrorCode() + ", message:" + levelPlayInitError.getErrorMessage();
                    Yodo1MasLog.d((String)Yodo1MasIronSourceMaxAdapter.this.TAG, (String)message);
                    if (callback != null) {
                        callback.onAdapterInitFailed(Yodo1MasIronSourceMaxAdapter.this.getAdvertCode(), new Yodo1MasError(-600001, message));
                    }
                }
            };
            LevelPlay.init((Context)activity, (LevelPlayInitRequest)builder.build(), (LevelPlayInitListener)initListener);
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        LevelPlay.setConsent((boolean)Yodo1MasHelper.getInstance().isGDPRUserConsent());
        LevelPlay.setMetaData((String)"do_not_sell", (String)Boolean.toString(Yodo1MasHelper.getInstance().isCCPADoNotSell()));
        boolean isAgeRestricted = Yodo1MasHelper.getInstance().isCOPPAAgeRestricted();
        LevelPlay.setMetaData((String)"is_child_directed", (String)Boolean.toString(isAgeRestricted));
        LevelPlay.setMetaData((String)"is_deviceid_optout", (String)Boolean.toString(isAgeRestricted));
        boolean isChild = Yodo1MasHelper.getInstance().isCOPPAAgeRestricted();
        String isChildBoolean = isChild ? "true" : "false";
        LevelPlay.setMetaData((String)"AdMob_TFCD", (String)isChildBoolean);
        LevelPlay.setMetaData((String)"AdMob_TFUA", (String)isChildBoolean);
        LevelPlay.setMetaData((String)"AppLovin_AgeRestrictedUser", (String)isChildBoolean);
        LevelPlay.setMetaData((String)"BidMachine_COPPA", (String)isChildBoolean);
        IronSource.setMetaData((String)"Chartboost_Coppa", (String)isChildBoolean);
        if (isChild) {
            LevelPlay.setMetaData((String)"META_Mixed_Audience", (String)isChildBoolean);
        }
        if (isChild) {
            LevelPlay.setMetaData((String)"DT_IsChild", (String)isChildBoolean);
        }
        LevelPlay.setMetaData((String)"InMobi_AgeRestricted", (String)isChildBoolean);
        LevelPlay.setMetaData((String)"Mintegral_COPPA", (String)isChildBoolean);
        LevelPlay.setMetaData((String)"Moloco_COPPA", (String)isChildBoolean);
        String isChildInt = isChild ? "1" : "0";
        LevelPlay.setMetaData((String)"Pangle_COPPA", (String)isChildInt);
        LevelPlay.setMetaData((String)"UnityAds_coppa", (String)isChildBoolean);
        LevelPlay.setMetaData((String)"Vungle_coppa", (String)isChildBoolean);
        LevelPlay.setMetaData((String)"Yandex_COPPA", (String)isChildBoolean);
    }

    public void onActivityResume(@NonNull Activity activity) {
        super.onActivityResume(activity);
        if (!this.isInitSDK()) {
            return;
        }
        IronSource.onResume((Activity)activity);
    }

    public void onActivityPause(@NonNull Activity activity) {
        super.onActivityPause(activity);
        if (!this.isInitSDK()) {
            return;
        }
        IronSource.onPause((Activity)activity);
    }

    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasIronSourceMaxRewardAdapter.class;
    }

    public Yodo1MasRewardAdapterBase getRewardAdapter(Yodo1MasAdapterBase.AdId rewardAdId) {
        Yodo1MasIronSourceMaxRewardAdapter adapter = (Yodo1MasIronSourceMaxRewardAdapter)super.getRewardAdapter(rewardAdId);
        return adapter;
    }

    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasIronSourceMaxInterstitialAdapter.class;
    }

    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasIronSourceMaxBannerAdapter.class;
    }

    public Yodo1MasBannerAdapterBase getBannerAdapter() {
        Yodo1MasIronSourceMaxBannerAdapter bannerAdapter = (Yodo1MasIronSourceMaxBannerAdapter)super.getBannerAdapter();
        bannerAdapter.setMax(this.isMax());
        return bannerAdapter;
    }

    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}

