/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.unity3d.mediation.LevelPlayAdError;
import com.unity3d.mediation.LevelPlayAdInfo;
import com.unity3d.mediation.LevelPlayAdSize;
import com.unity3d.mediation.banner.LevelPlayBannerAdView;
import com.unity3d.mediation.banner.LevelPlayBannerAdViewListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.List;

public class Yodo1MasIronSourceMaxBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private LevelPlayBannerAdView bannerAd;
    private final LevelPlayBannerAdViewListener bannerListener = new LevelPlayBannerAdViewListener(){

        public void onAdLoaded(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            String message = "method: onAdLoaded, banner, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxBannerAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasIronSourceMaxBannerAdapter.this.adSource = levelPlayAdInfo.getAdNetwork();
            Yodo1MasIronSourceMaxBannerAdapter.this.price = levelPlayAdInfo.getRevenue() * 1000.0;
            Yodo1MasIronSourceMaxBannerAdapter.this.adNetworkUnitId = levelPlayAdInfo.getAdUnitId();
            Yodo1MasIronSourceMaxBannerAdapter.this.adSourceUnitId = levelPlayAdInfo.getInstanceId();
            Yodo1MasIronSourceMaxBannerAdapter.this.revenue = levelPlayAdInfo.getRevenue();
            Yodo1MasIronSourceMaxBannerAdapter.this.revenuePrecision = TextUtils.equals((CharSequence)"BID", (CharSequence)levelPlayAdInfo.getPrecision()) ? "exact" : "publisher_defined";
            Yodo1MasIronSourceMaxBannerAdapter.this.trackAdRequestSuccessed();
            Yodo1MasIronSourceMaxBannerAdapter.this.callback(1003, Yodo1MasIronSourceMaxBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceMaxBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
            Yodo1MasIronSourceMaxBannerAdapter.this.callbackAdapterState();
        }

        public void onAdLoadFailed(@NonNull LevelPlayAdError levelPlayAdError) {
            String message = "method: onAdLoadFailed, banner, AdUnitId: " + levelPlayAdError.getAdUnitId() + ", errorCode: " + levelPlayAdError.getErrorCode() + " errorMessage: " + levelPlayAdError.getErrorMessage();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxBannerAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxBannerAdapter.this.price = 0.0;
            Yodo1MasIronSourceMaxBannerAdapter.this.revenue = 0.0;
            Yodo1MasIronSourceMaxBannerAdapter.this.adSource = "";
            Yodo1MasIronSourceMaxBannerAdapter.this.trackAdRequestFailed(levelPlayAdError.getErrorCode(), levelPlayAdError.getErrorMessage());
            Yodo1MasIronSourceMaxBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            if (Yodo1MasIronSourceMaxBannerAdapter.this.isMax()) {
                Yodo1MasIronSourceMaxBannerAdapter.this.handleLoadFailedCallback(message);
                Yodo1MasIronSourceMaxBannerAdapter.this.nextBanner();
                Yodo1MasIronSourceMaxBannerAdapter.this.loadBannerAdvertDelayed();
            } else if (Yodo1MasIronSourceMaxBannerAdapter.this.isLastPlacement()) {
                Yodo1MasIronSourceMaxBannerAdapter.this.handleLoadFailedCallback(message);
            } else {
                Yodo1MasIronSourceMaxBannerAdapter.this.nextBanner();
                Yodo1MasIronSourceMaxBannerAdapter.this.loadBannerAdvertDelayed();
            }
        }

        public void onAdDisplayed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            super.onAdDisplayed(levelPlayAdInfo);
            String message = "method: onAdDisplayed, banner, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxBannerAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasIronSourceMaxBannerAdapter.this.callback(1001, Yodo1MasIronSourceMaxBannerAdapter.this.TAG + ":{" + message + "}");
        }

        public void onAdDisplayFailed(@NonNull LevelPlayAdInfo levelPlayAdInfo, @NonNull LevelPlayAdError levelPlayAdError) {
            super.onAdDisplayFailed(levelPlayAdInfo, levelPlayAdError);
            String message = "method: onAdDisplayFailed, banner, AdUnitId: " + levelPlayAdError.getAdUnitId() + ", errorCode: " + levelPlayAdError.getErrorCode() + " errorMessage: " + levelPlayAdError.getErrorMessage();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxBannerAdapter.this.TAG, (String)message);
        }

        public void onAdClicked(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            super.onAdClicked(levelPlayAdInfo);
            String message = "method: onAdClicked, banner, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", error: " + levelPlayAdInfo.getAdUnitId();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxBannerAdapter.this.TAG, (String)message);
        }

        public void onAdExpanded(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            super.onAdExpanded(levelPlayAdInfo);
        }

        public void onAdLeftApplication(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            super.onAdLeftApplication(levelPlayAdInfo);
        }

        public void onAdCollapsed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            super.onAdCollapsed(levelPlayAdInfo);
        }
    };

    public Yodo1MasIronSourceMaxBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    public boolean isMax() {
        return this.isMax;
    }

    public void setMax(boolean max) {
        this.isMax = max;
    }

    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return this.bannerAd != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (this.relateAdapter != null && !this.relateAdapter.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (!this.isMax() && adId != null && adId.object != null && !this.isPriceValuable(adId)) {
            this.handlePricyNotAbaliable();
            return;
        }
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId)) {
            if (this.bannerAd == null) {
                LevelPlayAdSize adSize = this.getBannerSize(activity.getApplicationContext());
                LevelPlayBannerAdView.Config.Builder builder = new LevelPlayBannerAdView.Config.Builder();
                builder.setAdSize(adSize);
                if (!TextUtils.isEmpty((CharSequence)this.placement)) {
                    builder.setPlacementName(this.placement);
                }
                this.bannerAd = new LevelPlayBannerAdView((Context)activity, adId.adId, builder.build());
            }
            if (this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
                String message = "method: loadBannerAdvert, loading banner ad...";
                Yodo1MasLog.d((String)this.TAG, (String)message);
                this.bannerAd.setBannerListener(this.bannerListener);
                this.bannerAd.loadAd();
                this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
                this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADING;
            }
        }
    }

    private LevelPlayAdSize getBannerSize(Context context) {
        Yodo1MasBannerAdSize size = this.bannerConfig.size;
        Yodo1MasLog.d((String)this.TAG, (String)("setBannerSize: size: " + size.name()));
        LevelPlayAdSize bannerSize = LevelPlayAdSize.BANNER;
        if (Yodo1MasBannerAdSize.LargeBanner == size) {
            bannerSize = LevelPlayAdSize.LARGE;
        } else if (Yodo1MasBannerAdSize.IABMediumRectangle == size) {
            bannerSize = LevelPlayAdSize.MEDIUM_RECTANGLE;
        } else if (Yodo1MasBannerAdSize.AdaptiveBanner == size) {
            bannerSize = LevelPlayAdSize.createAdaptiveAdSize((Context)context);
        }
        return bannerSize;
    }

    public View getBannerView() {
        return this.bannerAd;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            this.bannerAd.destroy();
            this.bannerAd = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return super.isSupportMultipleInstance();
    }

    private void handleLoadFailedCallback(String message) {
        Yodo1MasError error = new Yodo1MasError(-600202, this.TAG + ":{" + message + "}");
        this.callback(error);
        this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
        this.callbackAdapterState();
    }
}

