/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.unity3d.mediation.LevelPlayAdError;
import com.unity3d.mediation.LevelPlayAdInfo;
import com.unity3d.mediation.interstitial.LevelPlayInterstitialAd;
import com.unity3d.mediation.interstitial.LevelPlayInterstitialAdListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasIronSourceMaxInterstitialAdapter
extends Yodo1MasInterstitialAdapterBase {
    private LevelPlayInterstitialAd interstitialAd;
    private final LevelPlayInterstitialAdListener adListener = new LevelPlayInterstitialAdListener(){

        public void onAdLoaded(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            String message = "method: onAdLoaded, interstitial, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxInterstitialAdapter.this.adSource = levelPlayAdInfo.getAdNetwork();
            Yodo1MasIronSourceMaxInterstitialAdapter.this.price = levelPlayAdInfo.getRevenue() * 1000.0;
            Yodo1MasIronSourceMaxInterstitialAdapter.this.adNetworkUnitId = levelPlayAdInfo.getAdUnitId();
            Yodo1MasIronSourceMaxInterstitialAdapter.this.adSourceUnitId = levelPlayAdInfo.getInstanceId();
            Yodo1MasIronSourceMaxInterstitialAdapter.this.revenue = levelPlayAdInfo.getRevenue();
            Yodo1MasIronSourceMaxInterstitialAdapter.this.revenuePrecision = TextUtils.equals((CharSequence)"BID", (CharSequence)levelPlayAdInfo.getPrecision()) ? "exact" : "publisher_defined";
            Yodo1MasIronSourceMaxInterstitialAdapter.this.adRequestResult = Yodo1MasAdRequestTrackUtil.getMediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Interstitial, (String)Yodo1MasIronSourceMaxInterstitialAdapter.this.advertCode, (String)Yodo1MasIronSourceMaxInterstitialAdapter.this.adSource, (String)Yodo1MasIronSourceMaxInterstitialAdapter.this.adNetworkUnitId, (boolean)true, (long)Yodo1MasIronSourceMaxInterstitialAdapter.this.getAdLoadDuration(), null, null);
            Yodo1MasIronSourceMaxInterstitialAdapter.this.callbackLoad(Yodo1MasIronSourceMaxInterstitialAdapter.this.adRequestResult);
        }

        public void onAdLoadFailed(@NonNull LevelPlayAdError levelPlayAdError) {
            String message = "method: onAdLoadFailed, interstitial, AdUnitId: " + levelPlayAdError.getAdUnitId() + ", errorCode: " + levelPlayAdError.getErrorCode() + " errorMessage: " + levelPlayAdError.getErrorMessage();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxInterstitialAdapter.this.price = 0.0;
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasIronSourceMaxInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceMaxInterstitialAdapter.this.adRequestResult = Yodo1MasAdRequestTrackUtil.getMediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Interstitial, (String)Yodo1MasIronSourceMaxInterstitialAdapter.this.advertCode, (String)Yodo1MasIronSourceMaxInterstitialAdapter.this.adSource, (String)Yodo1MasIronSourceMaxInterstitialAdapter.this.getAdUnitId(), (boolean)false, (long)Yodo1MasIronSourceMaxInterstitialAdapter.this.getAdLoadDuration(), (String)(levelPlayAdError.getErrorCode() + ""), (String)levelPlayAdError.getErrorMessage());
            Yodo1MasIronSourceMaxInterstitialAdapter.this.callbackError(error, levelPlayAdError.getErrorCode(), levelPlayAdError.getErrorMessage(), Yodo1MasIronSourceMaxInterstitialAdapter.this.adRequestResult);
        }

        public void onAdDisplayed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            String message = "method: onAdDisplayed, interstitial, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxInterstitialAdapter.this.callbackOpen();
        }

        public void onAdDisplayFailed(@NonNull LevelPlayAdError levelPlayAdError, @NonNull LevelPlayAdInfo levelPlayAdInfo) {
            super.onAdDisplayFailed(levelPlayAdError, levelPlayAdInfo);
            String message = "method: onAdDisplayFailed, interstitial, AdUnitId: " + levelPlayAdError.getAdUnitId() + ", errorCode: " + levelPlayAdError.getErrorCode() + " errorMessage: " + levelPlayAdError.getErrorMessage();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxInterstitialAdapter.this.price = 0.0;
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasIronSourceMaxInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceMaxInterstitialAdapter.this.callbackError(error, levelPlayAdError.getErrorCode(), levelPlayAdError.getErrorMessage(), null);
        }

        public void onAdClicked(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            super.onAdClicked(levelPlayAdInfo);
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxInterstitialAdapter.this.TAG, (String)"onAdClicked: ");
            Yodo1MasIronSourceMaxInterstitialAdapter.this.callbackClick();
        }

        public void onAdClosed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            super.onAdClosed(levelPlayAdInfo);
            String message = "method: onAdClosed, interstitial, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxInterstitialAdapter.this.price = 0.0;
            Yodo1MasIronSourceMaxInterstitialAdapter.this.revenue = 0.0;
            Yodo1MasIronSourceMaxInterstitialAdapter.this.callbackClose();
        }
    };

    public Yodo1MasIronSourceMaxInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    public boolean isInterstitialAdLoaded() {
        return this.interstitialAd != null && this.interstitialAd.isAdReady();
    }

    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = this.getAdUnitId();
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (!this.isNetworkInited()) {
            String message = "method: loadInterstitialAdvert, the IRONSOURCE mediation sdk has not been initialized yet ";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, this.TAG + ":{" + message + "}");
            String tdErrorMsg = "Yodo1Mas IRONSOURCE mediation error: the ironsource mediation sdk has not been initialized yet";
            this.adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Interstitial, (String)this.advertCode, (String)this.getAdUnitId(), (boolean)false, (long)0L, null, (String)tdErrorMsg);
            this.callbackError(error, 0, tdErrorMsg, this.adRequestResult);
            return;
        }
        if (this.interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        this.interstitialAd = new LevelPlayInterstitialAd(adId);
        this.interstitialAd.setListener(this.adListener);
        this.interstitialAd.loadAd();
    }

    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (this.isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            if (!TextUtils.isEmpty((CharSequence)this.placement)) {
                this.interstitialAd.showAd(activity, this.placement);
            } else {
                this.interstitialAd.showAd(activity);
            }
        }
    }
}

