/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.unity3d.mediation.LevelPlayAdError;
import com.unity3d.mediation.LevelPlayAdInfo;
import com.unity3d.mediation.rewarded.LevelPlayReward;
import com.unity3d.mediation.rewarded.LevelPlayRewardedAd;
import com.unity3d.mediation.rewarded.LevelPlayRewardedAdListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasIronSourceMaxRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private LevelPlayRewardedAd rewardedAd;
    private final LevelPlayRewardedAdListener adListener = new LevelPlayRewardedAdListener(){

        public void onAdLoaded(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            String message = "method: onAdLoaded, reward, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxRewardAdapter.this.adSource = levelPlayAdInfo.getAdNetwork();
            Yodo1MasIronSourceMaxRewardAdapter.this.price = levelPlayAdInfo.getRevenue() * 1000.0;
            Yodo1MasIronSourceMaxRewardAdapter.this.adNetworkUnitId = levelPlayAdInfo.getAdUnitId();
            Yodo1MasIronSourceMaxRewardAdapter.this.adSourceUnitId = levelPlayAdInfo.getInstanceId();
            Yodo1MasIronSourceMaxRewardAdapter.this.revenue = levelPlayAdInfo.getRevenue();
            Yodo1MasIronSourceMaxRewardAdapter.this.revenuePrecision = TextUtils.equals((CharSequence)"BID", (CharSequence)levelPlayAdInfo.getPrecision()) ? "exact" : "publisher_defined";
            Yodo1MasIronSourceMaxRewardAdapter.this.adRequestResult = Yodo1MasAdRequestTrackUtil.getMediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Reward, (String)Yodo1MasIronSourceMaxRewardAdapter.this.advertCode, (String)Yodo1MasIronSourceMaxRewardAdapter.this.adSource, (String)Yodo1MasIronSourceMaxRewardAdapter.this.adNetworkUnitId, (boolean)true, (long)Yodo1MasIronSourceMaxRewardAdapter.this.getAdLoadDuration(), null, null);
            Yodo1MasIronSourceMaxRewardAdapter.this.callbackLoad(Yodo1MasIronSourceMaxRewardAdapter.this.adRequestResult);
        }

        public void onAdLoadFailed(@NonNull LevelPlayAdError levelPlayAdError) {
            String message = "method: onAdLoadFailed, reward, AdUnitId: " + levelPlayAdError.getAdUnitId() + ", errorCode: " + levelPlayAdError.getErrorCode() + " errorMessage: " + levelPlayAdError.getErrorMessage();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxRewardAdapter.this.price = 0.0;
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasIronSourceMaxRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceMaxRewardAdapter.this.adRequestResult = Yodo1MasAdRequestTrackUtil.getMediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Reward, (String)Yodo1MasIronSourceMaxRewardAdapter.this.advertCode, (String)Yodo1MasIronSourceMaxRewardAdapter.this.adSource, (String)Yodo1MasIronSourceMaxRewardAdapter.this.getAdUnitId(), (boolean)false, (long)Yodo1MasIronSourceMaxRewardAdapter.this.getAdLoadDuration(), (String)(levelPlayAdError.getErrorCode() + ""), (String)levelPlayAdError.getErrorMessage());
            Yodo1MasIronSourceMaxRewardAdapter.this.callbackError(error, levelPlayAdError.getErrorCode(), levelPlayAdError.getErrorMessage(), Yodo1MasIronSourceMaxRewardAdapter.this.adRequestResult);
        }

        public void onAdDisplayed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            String message = "method: onAdDisplayed, reward, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxRewardAdapter.this.callbackOpen();
        }

        public void onAdDisplayFailed(@NonNull LevelPlayAdError levelPlayAdError, @NonNull LevelPlayAdInfo levelPlayAdInfo) {
            super.onAdDisplayFailed(levelPlayAdError, levelPlayAdInfo);
            String message = "method: onAdDisplayFailed, reward, AdUnitId: " + levelPlayAdError.getAdUnitId() + ", errorCode: " + levelPlayAdError.getErrorCode() + " errorMessage: " + levelPlayAdError.getErrorMessage();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxRewardAdapter.this.price = 0.0;
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasIronSourceMaxRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceMaxRewardAdapter.this.callbackError(error, levelPlayAdError.getErrorCode(), levelPlayAdError.getErrorMessage(), null);
        }

        public void onAdClicked(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            super.onAdClicked(levelPlayAdInfo);
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxRewardAdapter.this.TAG, (String)"onAdClicked: ");
            Yodo1MasIronSourceMaxRewardAdapter.this.callbackClick();
        }

        public void onAdClosed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
            super.onAdClosed(levelPlayAdInfo);
            String message = "method: onAdClosed, reward, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxRewardAdapter.this.price = 0.0;
            Yodo1MasIronSourceMaxRewardAdapter.this.revenue = 0.0;
            Yodo1MasIronSourceMaxRewardAdapter.this.callbackClose();
        }

        public void onAdRewarded(@NonNull LevelPlayReward levelPlayReward, @NonNull LevelPlayAdInfo levelPlayAdInfo) {
            String message = "method: onAdRewarded, reward, AdUnitId: " + levelPlayAdInfo.getAdUnitId() + ", NetworkName: " + levelPlayAdInfo.getAdNetwork();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxRewardAdapter.this.callbackEarned();
        }
    };

    public Yodo1MasIronSourceMaxRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    public boolean isRewardAdLoaded() {
        return this.rewardedAd != null && this.rewardedAd.isAdReady();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = this.getAdUnitId();
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (!this.isNetworkInited()) {
            String message = "method: loadRewardAdvert, the IRONSOURCE mediation sdk has not been initialized yet ";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, this.TAG + ":{" + message + "}");
            String tdErrorMsg = "Yodo1Mas IRONSOURCE mediation error: the ironsource mediation sdk has not been initialized yet";
            this.adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Reward, (String)this.advertCode, (String)this.getAdUnitId(), (boolean)false, (long)0L, null, (String)tdErrorMsg);
            this.callbackError(error, 0, tdErrorMsg, this.adRequestResult);
            return;
        }
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        this.rewardedAd = new LevelPlayRewardedAd(adId);
        this.rewardedAd.setListener(this.adListener);
        this.rewardedAd.loadAd();
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            if (TextUtils.isEmpty((CharSequence)this.placement)) {
                this.rewardedAd.showAd(activity);
            } else {
                this.rewardedAd.showAd(activity, this.placement);
            }
        }
    }

    public void destroy() {
        super.destroy();
    }
}

