package com.yodo1.mas.mediation.mintegral;

import android.app.Activity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.mbridge.msdk.MBridgeConstans;
import com.mbridge.msdk.MBridgeSDK;
import com.mbridge.msdk.out.MBridgeSDKFactory;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasMintegralAdapter extends Yodo1MasAdapterBase {

    /**
     * Set Mintegral's privacy
     * About Mintegral's privacy, please see this link https://dev.mintegral.com/doc/index.html?file=sdk-m_sdk-android&lang=en#sdkprivacycompliancestatement
     *
     * @param activity Activity
     */
    public static void setMintegralPrivacy(@NonNull Activity activity) {
        MBridgeSDK sdk = MBridgeSDKFactory.getMBridgeSDK();
        sdk.setConsentStatus(activity, Yodo1MasHelper.getInstance().isGDPRUserConsent() ? MBridgeConstans.IS_SWITCH_ON : MBridgeConstans.IS_SWITCH_OFF); // GDPR

        sdk.setDoNotTrackStatus(Yodo1MasHelper.getInstance().isCCPADoNotSell()); //CCPA
    }

    @Override
    public String getAdvertCode() {
        return "mintegral";
    }

    @Override
    public String networkName() {
        return "Mintegral";
    }

    @Override
    public String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        setMintegralPrivacy(currentActivity);
    }

    @Override
    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return null;
    }

    @Override
    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return null;
    }

    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return null;
    }

    @Override
    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    @Override
    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }


}
