package com.yodo1.mas.mediation.mintegral;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.mbridge.msdk.out.MBRewardVideoHandler;
import com.mbridge.msdk.out.MBridgeIds;
import com.mbridge.msdk.out.RewardInfo;
import com.mbridge.msdk.out.RewardVideoListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasMintegralRewardAdapter extends Yodo1MasRewardAdapterBase {

    private final RewardVideoListener rewardAdLister = new RewardVideoListener() {
        @Override
        public void onVideoLoadSuccess(MBridgeIds mBridgeIds) {
            Yodo1MasLog.d(TAG, "method: onVideoLoadSuccess, unitId: " + mBridgeIds.getUnitId() + " requestId: " + rewardAd.getRequestId());
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, mBridgeIds.getUnitId(), true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onLoadSuccess(MBridgeIds mBridgeIds) {
            Yodo1MasLog.d(TAG, "method: onLoadSuccess, unitId: " + mBridgeIds.getUnitId() + " requestId: " + rewardAd.getRequestId());
        }

        @Override
        public void onVideoLoadFail(MBridgeIds mBridgeIds, String s) {
            String msg = "method: onVideoLoadFail, unitId: " + mBridgeIds.getUnitId() + ", message: " + s + " requestId: " + rewardAd.getRequestId();
            Yodo1MasLog.d(TAG, msg);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + msg + "}");
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, mBridgeIds.getUnitId(), false, getAdLoadDuration(), 0 + "", s);
            callbackError(error, 0, s, adRequestResult);
        }

        @Override
        public void onAdShow(MBridgeIds mBridgeIds) {
            String message = "method: onAdShow, unitId: " + mBridgeIds.getUnitId() + " requestId: " + rewardAd.getRequestId();
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdClose(MBridgeIds mBridgeIds, RewardInfo rewardInfo) {
            //如果rewardInfo.isCompleteView()返回true,代表可以给用户奖励
            if (rewardInfo.isCompleteView()) {
                Yodo1MasLog.d(TAG, "will callback Earned");
                callbackEarned();
            }
            String message = "method: onAdClose, unitId: " + mBridgeIds.getUnitId() + " requestId: " + rewardAd.getRequestId();
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onShowFail(MBridgeIds mBridgeIds, String s) {
            String message = "method: onShowFail, unitId: " + mBridgeIds.getUnitId() + " requestId: " + rewardAd.getRequestId();
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, 0, "", null);
        }

        @Override
        public void onVideoAdClicked(MBridgeIds mBridgeIds) {
            String message = "method: onVideoAdClicked, unitId: " + mBridgeIds.getUnitId() + " requestId: " + rewardAd.getRequestId();
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onVideoComplete(MBridgeIds mBridgeIds) {
            String message = "method: onVideoComplete, unitId: " + mBridgeIds.getUnitId() + " requestId: " + rewardAd.getRequestId();
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onEndcardShow(MBridgeIds mBridgeIds) {
            String message = "method: onEndcardShow, unitId: " + mBridgeIds.getUnitId() + " requestId: " + rewardAd.getRequestId();
            Yodo1MasLog.d(TAG, message);
        }
    };

    private MBRewardVideoHandler rewardAd;

    public Yodo1MasMintegralRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && rewardAd.isReady();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);

        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d(TAG, message);

        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();

        rewardAd = new MBRewardVideoHandler(activity, null, adId);
        rewardAd.setRewardPlus(true);
        rewardAd.setRewardVideoListener(rewardAdLister);
        rewardAd.load();
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d(TAG, message);
            rewardAd.show();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (rewardAd != null) {
            rewardAd = null;
        }
    }
}
