/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.mintegral;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mbridge.msdk.out.MBridgeSDKFactory;
import com.mbridge.msdk.out.SDKInitStatusListener;
import com.mbridge.msdk.system.MBridgeSDKImpl;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.mintegral.Yodo1MasMintegralInterstitialAdapter;
import com.yodo1.mas.mediation.mintegral.Yodo1MasMintegralRewardAdapter;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;
import java.util.Map;

public class Yodo1MasMintegralAdapter
extends Yodo1MasAdapterBase {
    public static void setMintegralPrivacy(@NonNull Activity activity) {
        MBridgeSDKImpl sdk = MBridgeSDKFactory.getMBridgeSDK();
        sdk.setCoppaStatus(activity.getApplicationContext(), Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
        sdk.setDoNotTrackStatus(activity.getApplicationContext(), Yodo1MasHelper.getInstance().isCCPADoNotSell());
    }

    private void setMintegralGDPRPrivacy(@NonNull Activity activity) {
        MBridgeSDKImpl sdk = MBridgeSDKFactory.getMBridgeSDK();
        sdk.setConsentStatus((Context)activity, Yodo1MasHelper.getInstance().isGDPRUserConsent() ? 1 : 0);
    }

    public String getAdvertCode() {
        return "mintegral";
    }

    public String networkName() {
        return "Mintegral";
    }

    public String getSDKVersion() {
        return "16.9.41";
    }

    public String getMediationVersion() {
        return "4.15.0";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (this.isInitSDK()) {
            if (callback != null) {
                callback.onAdapterInitSuccessful(this.getAdvertCode());
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)config.appId)) {
            if (callback != null) {
                callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
            }
            return;
        }
        this.init = true;
        MBridgeSDKImpl sdk = MBridgeSDKFactory.getMBridgeSDK();
        Map map = sdk.getMBConfigurationMap(config.appId, config.appKey);
        this.setMintegralGDPRPrivacy(activity);
        sdk.init(map, activity.getApplication(), new SDKInitStatusListener(){

            public void onInitSuccess() {
                String message = "method: onInitSuccess";
                Yodo1MasLog.d((String)Yodo1MasMintegralAdapter.this.TAG, (String)message);
                Yodo1MasMintegralAdapter.this.updatePrivacy();
            }

            public void onInitFail(String errorMsg) {
                String message = "method: onInitFail, errorMsg: " + errorMsg;
                Yodo1MasLog.d((String)Yodo1MasMintegralAdapter.this.TAG, (String)message);
            }
        });
        if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        Yodo1MasMintegralAdapter.setMintegralPrivacy(this.currentActivity);
    }

    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasMintegralRewardAdapter.class;
    }

    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasMintegralInterstitialAdapter.class;
    }

    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}

