package com.yodo1.mas.mediation.mintegral;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.mbridge.msdk.MBridgeConstans;
import com.mbridge.msdk.MBridgeSDK;
import com.mbridge.msdk.out.MBridgeSDKFactory;
import com.mbridge.msdk.out.SDKInitStatusListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

import java.util.Map;

public class Yodo1MasMintegralAdapter extends Yodo1MasAdapterBase {

    /**
     * Set Mintegral's privacy
     * About Mintegral's privacy, please see this link <a href="https://dev.mintegral.com/doc/index.html?file=sdk-m_sdk-android&lang=en#sdkprivacycompliancestatement">...</a>
     *
     * @param activity Activity
     */
    public static void setMintegralPrivacy(@NonNull Activity activity) {
        MBridgeSDK sdk = MBridgeSDKFactory.getMBridgeSDK();
        sdk.setCoppaStatus(activity.getApplicationContext(),Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
        sdk.setDoNotTrackStatus(activity.getApplicationContext(), Yodo1MasHelper.getInstance().isCCPADoNotSell()); //CCPA
    }

    /**
     * Set Mintegral's GDPR privacy
     * need call before initialization the Mintegral SDK
     */
    private void setMintegralGDPRPrivacy(@NonNull Activity activity) {
        MBridgeSDK sdk = MBridgeSDKFactory.getMBridgeSDK();
        sdk.setConsentStatus(activity, Yodo1MasHelper.getInstance().isGDPRUserConsent() ? MBridgeConstans.IS_SWITCH_ON : MBridgeConstans.IS_SWITCH_OFF); // GDPR
    }

    @Override
    public String getAdvertCode() {
        return "mintegral";
    }

    @Override
    public String networkName() {
        return "Mintegral";
    }

    @Override
    public String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (isInitSDK()) {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
            return;
        }

        if (TextUtils.isEmpty(config.appId)) {
            if (callback != null) {
                callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, "config.appId is null"));
            }
            return;
        }

        init = true;
        MBridgeSDK sdk = MBridgeSDKFactory.getMBridgeSDK();
        Map<String, String> map = sdk.getMBConfigurationMap(config.appId, config.appKey);
        setMintegralGDPRPrivacy(activity);
        sdk.init(map, activity.getApplication(), new SDKInitStatusListener() {
            @Override
            public void onInitSuccess() {
                String message = "method: onInitSuccess";
                Yodo1MasLog.d(TAG, message);
                updatePrivacy();
            }

            @Override
            public void onInitFail(String errorMsg) {
                String message = "method: onInitFail, errorMsg: " + errorMsg;
                Yodo1MasLog.d(TAG, message);
            }
        });

        if (callback != null) {
            callback.onAdapterInitSuccessful(getAdvertCode());
        }
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        setMintegralPrivacy(currentActivity);
    }

    @Override
    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasMintegralRewardAdapter.class;
    }

    @Override
    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasMintegralInterstitialAdapter.class;
    }

    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return null;
    }

    @Override
    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    @Override
    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }


}
