package com.yodo1.mas.mediation.mintegral;

import android.app.Activity;
import android.text.TextUtils;

import com.mbridge.msdk.newinterstitial.out.MBNewInterstitialHandler;
import com.mbridge.msdk.newinterstitial.out.NewInterstitialListener;
import com.mbridge.msdk.out.MBridgeIds;
import com.mbridge.msdk.out.RewardInfo;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasMintegralInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private final NewInterstitialListener interstitialListener = new NewInterstitialListener() {
        @Override
        public void onLoadCampaignSuccess(MBridgeIds mBridgeIds) {
            String msg = "method: onLoadCampaignSuccess, unitId: " + mBridgeIds.getUnitId();
            Yodo1MasLog.d(TAG, msg);
        }

        @Override
        public void onResourceLoadSuccess(MBridgeIds mBridgeIds) {
            Yodo1MasLog.d(TAG, "method: onResourceLoadSuccess, unitId: " + mBridgeIds.getUnitId() + " requestId: " + interstitialAd.getRequestId());
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, mBridgeIds.getUnitId(), true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onResourceLoadFail(MBridgeIds mBridgeIds, String s) {
            String msg = "method: onResourceLoadFail, unitId: " + mBridgeIds.getUnitId() + ", message: " + s + " requestId: " + interstitialAd.getRequestId();
            Yodo1MasLog.d(TAG, msg);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + msg + "}");
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, mBridgeIds.getUnitId(), false, getAdLoadDuration(), 0+"", s);
            callbackError(error, 0, s, adRequestResult);
        }

        @Override
        public void onAdShow(MBridgeIds mBridgeIds) {
            String message = "method: onAdShow, unitId: " + mBridgeIds.getUnitId() + " requestId: " + interstitialAd.getRequestId();
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdClose(MBridgeIds mBridgeIds, RewardInfo rewardInfo) {
            String message = "method: onAdClose, unitId: " + mBridgeIds.getUnitId() + " requestId: " + interstitialAd.getRequestId();
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onShowFail(MBridgeIds mBridgeIds, String s) {
            String msg = "method: onUnityAdsShowFailure, unitId: " + mBridgeIds.getUnitId() + ", error: " +  s + " requestId: " + interstitialAd.getRequestId();
            Yodo1MasLog.d(TAG, msg);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + msg + "}");
            callbackError(error, 0, s, null);
        }

        @Override
        public void onAdClicked(MBridgeIds mBridgeIds) {
            String message = "method: onAdClicked, unitId: " + mBridgeIds.getUnitId() + " requestId: " + interstitialAd.getRequestId();
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onVideoComplete(MBridgeIds mBridgeIds) {
            String message = "method: onVideoComplete, unitId: " + mBridgeIds.getUnitId() + " requestId: " + interstitialAd.getRequestId();
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdCloseWithNIReward(MBridgeIds mBridgeIds, RewardInfo rewardInfo) {
            String message = "method: onAdCloseWithNIReward, unitId: " + mBridgeIds.getUnitId() + " requestId: " + interstitialAd.getRequestId();
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onEndcardShow(MBridgeIds mBridgeIds) {
            String message = "method: onEndcardShow, unitId: " + mBridgeIds.getUnitId() + " requestId: " + interstitialAd.getRequestId();
            Yodo1MasLog.d(TAG, message);
        }
    };

    private MBNewInterstitialHandler interstitialAd;

    public Yodo1MasMintegralInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && interstitialAd.isReady();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);

        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d(TAG, message);

        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();

        interstitialAd = new MBNewInterstitialHandler(activity, null, adId);
        interstitialAd.setInterstitialVideoListener(interstitialListener);
        interstitialAd.load();
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);
            interstitialAd.show();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (interstitialAd != null) {
            interstitialAd = null;
        }
    }
}
