package com.yodo1.mas.mediation.mytarget;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.my.target.ads.InterstitialAd;
import com.my.target.ads.MyTargetView;
import com.my.target.ads.Reward;
import com.my.target.ads.RewardedAd;
import com.my.target.common.MyTargetPrivacy;
import com.my.target.common.MyTargetVersion;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.analytics.Yodo1MasSensorHelper;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.helper.Yodo1MasBanner;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import org.json.JSONObject;

public class Yodo1MasMyTargetAdapter extends Yodo1MasAdapterBase {

    private RewardedAd rewardAd;
    private String currentRewardId;
    private AdvertState rewardState = AdvertState.NONE;
    private InterstitialAd interstitialAd;
    private String currentInterstitialId;
    private AdvertState interstitialState = AdvertState.NONE;
    private MyTargetView bannerAd;
    private String currentBannerId;

    @Override
    public String getAdvertCode() {
        return "mytarget";
    }

    @Override
    public String getSDKVersion() {
        return MyTargetVersion.VERSION;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!isInitSDK()) {
            init = true;
            updatePrivacy();
            loadRewardAdvert();
            loadInterstitialAdvert();
            loadBannerAdvert();
        }
        if (callback != null) {
            callback.onAdapterInitSuccessful(getAdvertCode());
        }
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        MyTargetPrivacy.setUserConsent(Yodo1MasHelper.getInstance().isGDPRUserConsent());
        MyTargetPrivacy.setCcpaUserConsent(Yodo1MasHelper.getInstance().isCCPADoNotSell());
        MyTargetPrivacy.setUserAgeRestricted(Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
    }

    @Override
    public boolean isRewardAdvertLoaded() {
        super.isRewardAdvertLoaded();
        return rewardAd != null && rewardState == AdvertState.LOADED;
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!isInitSDK()) return;

        AdId adId = getRewardAdId();
        if (adId != null && !TextUtils.isEmpty(adId.adId) && (rewardAd == null || !adId.adId.equals(currentRewardId))) {
            rewardAd = new RewardedAd(Integer.parseInt(adId.adId), activity);
            rewardAd.setListener(rewardListener);
            currentRewardId = adId.adId;
        }
        if (rewardAd != null && rewardState != AdvertState.LOADING) {
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d(TAG, message);
            rewardAd.load();
            rewardState = AdvertState.LOADING;
        }
    }

    @Override
    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d(TAG, message);
            rewardAd.show();
            rewardState = AdvertState.NONE;
        }
    }

    @Override
    public void dismissRewardAdvert() {
        super.dismissRewardAdvert();
        if (rewardAd != null) {
            rewardAd.dismiss();
        }
        rewardAd = null;
    }

    @Override
    public boolean isInterstitialAdvertLoaded() {
        super.isInterstitialAdvertLoaded();
        return interstitialAd != null && interstitialState == AdvertState.LOADED;
    }

    @Override
    public void loadInterstitialAdvert(@NonNull Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (!isInitSDK()) return;

        AdId adId = getInterstitialAdId();
        if (adId != null && !TextUtils.isEmpty(adId.adId) && (interstitialAd == null || !adId.adId.equals(currentInterstitialId))) {
            interstitialAd = new InterstitialAd(Integer.parseInt(adId.adId), activity);
            interstitialAd.setListener(interstitialListener);
            currentInterstitialId = adId.adId;
        }
        if (interstitialAd != null && interstitialState != AdvertState.LOADING) {
            String message = "method: loadInterstitialAdvert, loading interstitial ad...";
            Log.d(TAG, message);
            interstitialAd.load();
            interstitialState = AdvertState.LOADING;
        }
    }

    @Override
    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);
        if (isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d(TAG, message);
            interstitialAd.show();
            interstitialState = AdvertState.NONE;
        }
    }

    @Override
    public void dismissInterstitialAdvert() {
        super.dismissInterstitialAdvert();
        if (interstitialAd != null) {
            interstitialAd.dismiss();
        }
        interstitialAd = null;
    }

    @Override
    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return bannerAd != null && bannerState == AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (!isInitSDK()) return;

        AdId adId = getBannerAdId();

        if (bannerAd == null) {
            bannerAd = new MyTargetView(activity);
            bannerAd.setListener(bannerListener);
        }
        if (adId != null && !TextUtils.isEmpty(adId.adId) && !adId.adId.equals(currentBannerId)) {
            bannerAd.setSlotId(Integer.parseInt(adId.adId));
            currentBannerId = adId.adId;
        }
        if (bannerAd != null && bannerState != AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Log.d(TAG, message);
            bannerAd.load();
            bannerState = AdvertState.LOADING;
        }
    }

    @Override
    public void showBannerAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable AdvertCallback callback) {
        super.showBannerAdvert(activity, object, callback);
        if (isCanShow(Yodo1Mas.AdType.Banner, callback)) {
            String message = "method: showBannerAdvert, show banner ad...";
            Log.d(TAG, message);
            Yodo1MasBanner.showBanner(activity, bannerAd, object);
        }
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        ;
        if (bannerAd != null) {
            Yodo1MasBanner.removeBanner(bannerAd);
            if (destroy) {
                bannerAd.destroy();
                bannerAd = null;
                bannerState = AdvertState.NONE;
                loadBannerAdvert();
            }
        }
    }

    @Override
    public void onActivityDestroy(@NonNull Activity activity) {
        super.onActivityDestroy(activity);
        if (bannerAd != null) {
            bannerAd.destroy();
            bannerAd = null;
        }
    }

    private final RewardedAd.RewardedAdListener rewardListener = new RewardedAd.RewardedAdListener() {
        @Override
        public void onLoad(@NonNull RewardedAd rewardedAd) {
            String message = "method: onLoad, reward: " + rewardedAd.getAdSource();
            Log.d(TAG, message);
            rewardState = AdvertState.LOADED;
            trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.SUCCESS);
        }

        @Override
        public void onNoAd(@NonNull String reason, @NonNull RewardedAd rewardedAd) {
            String message = "method: onNoAd, reward: " + rewardedAd.getAdSource() + ", reason: " + reason;
            Log.d(TAG, message);
            rewardState = AdvertState.NONE;
            trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.FAIL);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callback(error, Yodo1Mas.AdType.Reward);

            nextReward();
            loadRewardAdvertDelayed();
        }

        @Override
        public void onDisplay(@NonNull RewardedAd rewardedAd) {
            String message = "method: onDisplay, reward: " + rewardedAd.getAdSource();
            Log.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_OPENED, Yodo1Mas.AdType.Reward, TAG + ":{" + message + "}");
        }

        @Override
        public void onClick(@NonNull RewardedAd rewardedAd) {
            String message = "method: onClick, reward: " + rewardedAd.getAdSource();
            Log.d(TAG, message);
        }

        @Override
        public void onDismiss(@NonNull RewardedAd rewardedAd) {
            String message = "method: onDismiss, reward: " + rewardedAd.getAdSource();
            Log.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_CLOSED, Yodo1Mas.AdType.Reward, TAG + ":{" + message + "}");
            loadRewardAdvert();
        }

        @Override
        public void onReward(@NonNull Reward reward, @NonNull RewardedAd rewardedAd) {
            String message = "method: onReward, reward: " + rewardedAd.getAdSource();
            Log.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_REWARD_EARNED, Yodo1Mas.AdType.Reward, TAG + ":{" + message + "}");
        }
    };

    private final InterstitialAd.InterstitialAdListener interstitialListener = new InterstitialAd.InterstitialAdListener() {
        @Override
        public void onLoad(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onLoad, interstitial: " + interstitialAd.getAdSource();
            Log.d(TAG, message);
            interstitialState = AdvertState.LOADED;
            trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.SUCCESS);
        }

        @Override
        public void onNoAd(@NonNull String reason, @NonNull InterstitialAd interstitialAd) {
            String message = "method: onNoAd, interstitial: " + interstitialAd.getAdSource() + ", reason: " + reason;
            Log.d(TAG, message);
            interstitialState = AdvertState.NONE;
            trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.FAIL);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callback(error, Yodo1Mas.AdType.Interstitial);

            nextInterstitial();
            loadInterstitialAdvertDelayed();
        }

        @Override
        public void onDisplay(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onDisplay, interstitial: " + interstitialAd.getAdSource();
            Log.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_OPENED, Yodo1Mas.AdType.Interstitial, TAG + ":{" + message + "}");
        }

        @Override
        public void onClick(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onClick, interstitial: " + interstitialAd.getAdSource();
            Log.d(TAG, message);
        }

        @Override
        public void onDismiss(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onDismiss, interstitial: " + interstitialAd.getAdSource();
            Log.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_CLOSED, Yodo1Mas.AdType.Interstitial, TAG + ":{" + message + "}");
            loadInterstitialAdvert();
        }

        @Override
        public void onVideoCompleted(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onVideoCompleted, interstitial: " + interstitialAd.getAdSource();
            Log.d(TAG, message);
        }
    };

    private final MyTargetView.MyTargetViewListener bannerListener = new MyTargetView.MyTargetViewListener() {
        @Override
        public void onLoad(@NonNull MyTargetView myTargetView) {
            String message = "method: onLoad, banner: " + myTargetView.getAdSource();
            Log.d(TAG, message);
            bannerState = AdvertState.LOADED;
            trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.SUCCESS);
            callback(Yodo1MasAdEvent.CODE_LOADED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");
        }

        @Override
        public void onNoAd(@NonNull String reason, @NonNull MyTargetView myTargetView) {
            String message = "method: onNoAd, banner: " + myTargetView.getAdSource() + "reason: " + reason;
            Log.d(TAG, message);
            trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.FAIL);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callback(error, Yodo1Mas.AdType.Banner);

            nextBanner();
            bannerState = AdvertState.NONE;
            loadBannerAdvertDelayed();
        }

        @Override
        public void onShow(@NonNull MyTargetView myTargetView) {
            String message = "method: onLoggingImpression, banner: " + myTargetView.getAdSource();
            Log.d(TAG, message);
            bannerState = AdvertState.NONE;
            callback(Yodo1MasAdEvent.CODE_OPENED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");
        }

        @Override
        public void onClick(@NonNull MyTargetView myTargetView) {
            String message = "method: onClick, banner: " + myTargetView.getAdSource();
            Log.d(TAG, message);
        }
    };
}
