/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.mytarget;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.ads.InterstitialAd;
import com.my.target.ads.MyTargetView;
import com.my.target.ads.Reward;
import com.my.target.ads.RewardedAd;
import com.my.target.common.MyTargetPrivacy;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.analytics.Yodo1MasSensorHelper;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasBanner;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import org.json.JSONObject;

public class Yodo1MasMyTargetAdapter
extends Yodo1MasAdapterBase {
    private RewardedAd rewardAd;
    private String currentRewardId;
    private Yodo1MasAdapterBase.AdvertState rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
    private InterstitialAd interstitialAd;
    private String currentInterstitialId;
    private Yodo1MasAdapterBase.AdvertState interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
    private MyTargetView bannerAd;
    private String currentBannerId;
    private final RewardedAd.RewardedAdListener rewardListener = new RewardedAd.RewardedAdListener(){

        public void onLoad(@NonNull RewardedAd rewardedAd) {
            String message = "method: onLoad, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.rewardState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasMyTargetAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.SUCCESS);
        }

        public void onNoAd(@NonNull String reason, @NonNull RewardedAd rewardedAd) {
            String message = "method: onNoAd, reward: " + rewardedAd.getAdSource() + ", reason: " + reason;
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasMyTargetAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.FAIL);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasMyTargetAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
            Yodo1MasMyTargetAdapter.this.nextReward();
            Yodo1MasMyTargetAdapter.this.loadRewardAdvertDelayed();
        }

        public void onDisplay(@NonNull RewardedAd rewardedAd) {
            String message = "method: onDisplay, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.callback(1001, Yodo1Mas.AdType.Reward, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
        }

        public void onClick(@NonNull RewardedAd rewardedAd) {
            String message = "method: onClick, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
        }

        public void onDismiss(@NonNull RewardedAd rewardedAd) {
            String message = "method: onDismiss, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.callback(1002, Yodo1Mas.AdType.Reward, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasMyTargetAdapter.this.loadRewardAdvert();
        }

        public void onReward(@NonNull Reward reward, @NonNull RewardedAd rewardedAd) {
            String message = "method: onReward, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.callback(2001, Yodo1Mas.AdType.Reward, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
        }
    };
    private final InterstitialAd.InterstitialAdListener interstitialListener = new InterstitialAd.InterstitialAdListener(){

        public void onLoad(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onLoad, interstitial: " + interstitialAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.interstitialState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasMyTargetAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.SUCCESS);
        }

        public void onNoAd(@NonNull String reason, @NonNull InterstitialAd interstitialAd) {
            String message = "method: onNoAd, interstitial: " + interstitialAd.getAdSource() + ", reason: " + reason;
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasMyTargetAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.FAIL);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasMyTargetAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
            Yodo1MasMyTargetAdapter.this.nextInterstitial();
            Yodo1MasMyTargetAdapter.this.loadInterstitialAdvertDelayed();
        }

        public void onDisplay(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onDisplay, interstitial: " + interstitialAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.callback(1001, Yodo1Mas.AdType.Interstitial, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
        }

        public void onClick(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onClick, interstitial: " + interstitialAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
        }

        public void onDismiss(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onDismiss, interstitial: " + interstitialAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.callback(1002, Yodo1Mas.AdType.Interstitial, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasMyTargetAdapter.this.loadInterstitialAdvert();
        }

        public void onVideoCompleted(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onVideoCompleted, interstitial: " + interstitialAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
        }
    };
    private final MyTargetView.MyTargetViewListener bannerListener = new MyTargetView.MyTargetViewListener(){

        public void onLoad(@NonNull MyTargetView myTargetView) {
            String message = "method: onLoad, banner: " + myTargetView.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasMyTargetAdapter.this.trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.SUCCESS);
            Yodo1MasMyTargetAdapter.this.callback(1003, Yodo1Mas.AdType.Banner, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
        }

        public void onNoAd(@NonNull String reason, @NonNull MyTargetView myTargetView) {
            String message = "method: onNoAd, banner: " + myTargetView.getAdSource() + "reason: " + reason;
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.FAIL);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasMyTargetAdapter.this.callback(error, Yodo1Mas.AdType.Banner);
            Yodo1MasMyTargetAdapter.this.nextBanner();
            Yodo1MasMyTargetAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasMyTargetAdapter.this.loadBannerAdvertDelayed();
        }

        public void onShow(@NonNull MyTargetView myTargetView) {
            String message = "method: onLoggingImpression, banner: " + myTargetView.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasMyTargetAdapter.this.callback(1001, Yodo1Mas.AdType.Banner, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
        }

        public void onClick(@NonNull MyTargetView myTargetView) {
            String message = "method: onClick, banner: " + myTargetView.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
        }
    };

    public String getAdvertCode() {
        return "mytarget";
    }

    public String getSDKVersion() {
        return "5.11.12";
    }

    public String getMediationVersion() {
        return "4.2.1";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            this.updatePrivacy();
            this.loadRewardAdvert();
            this.loadInterstitialAdvert();
            this.loadBannerAdvert();
        }
        if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        MyTargetPrivacy.setUserConsent((boolean)Yodo1MasHelper.getInstance().isGDPRUserConsent());
        MyTargetPrivacy.setCcpaUserConsent((boolean)Yodo1MasHelper.getInstance().isCCPADoNotSell());
        MyTargetPrivacy.setUserAgeRestricted((boolean)Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
    }

    public boolean isRewardAdvertLoaded() {
        super.isRewardAdvertLoaded();
        return this.rewardAd != null && this.rewardState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getRewardAdId();
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || this.rewardAd != null && adId.adId.equals(this.currentRewardId))) {
            this.rewardAd = new RewardedAd(Integer.parseInt(adId.adId), (Context)activity);
            this.rewardAd.setListener(this.rewardListener);
            this.currentRewardId = adId.adId;
        }
        if (this.rewardAd != null && this.rewardState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardAd.load();
            this.rewardState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardAd.show();
            this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
        }
    }

    public void dismissRewardAdvert() {
        super.dismissRewardAdvert();
        if (this.rewardAd != null) {
            this.rewardAd.dismiss();
        }
        this.rewardAd = null;
    }

    public boolean isInterstitialAdvertLoaded() {
        super.isInterstitialAdvertLoaded();
        return this.interstitialAd != null && this.interstitialState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadInterstitialAdvert(@NonNull Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getInterstitialAdId();
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || this.interstitialAd != null && adId.adId.equals(this.currentInterstitialId))) {
            this.interstitialAd = new InterstitialAd(Integer.parseInt(adId.adId), (Context)activity);
            this.interstitialAd.setListener(this.interstitialListener);
            this.currentInterstitialId = adId.adId;
        }
        if (this.interstitialAd != null && this.interstitialState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadInterstitialAdvert, loading interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            this.interstitialAd.load();
            this.interstitialState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            this.interstitialAd.show();
            this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
        }
    }

    public void dismissInterstitialAdvert() {
        super.dismissInterstitialAdvert();
        if (this.interstitialAd != null) {
            this.interstitialAd.dismiss();
        }
        this.interstitialAd = null;
    }

    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return this.bannerAd != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (this.bannerAd == null) {
            this.bannerAd = new MyTargetView((Context)activity);
            this.bannerAd.setListener(this.bannerListener);
        }
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && !adId.adId.equals(this.currentBannerId)) {
            this.bannerAd.setSlotId(Integer.parseInt(adId.adId));
            this.currentBannerId = adId.adId;
        }
        if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Log.d((String)this.TAG, (String)message);
            this.bannerAd.load();
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showBannerAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showBannerAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Banner, callback)) {
            String message = "method: showBannerAdvert, show banner ad...";
            Log.d((String)this.TAG, (String)message);
            Yodo1MasBanner.showBanner((Activity)activity, (View)this.bannerAd, (JSONObject)object);
        }
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null) {
            Yodo1MasBanner.removeBanner((View)this.bannerAd);
            if (destroy) {
                this.bannerAd.destroy();
                this.bannerAd = null;
                this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                this.loadBannerAdvert();
            }
        }
    }

    public void onActivityDestroy(@NonNull Activity activity) {
        super.onActivityDestroy(activity);
        if (this.bannerAd != null) {
            this.bannerAd.destroy();
            this.bannerAd = null;
        }
    }
}

