package com.yodo1.mas.mediation.mytarget;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;

import com.my.target.ads.MyTargetView;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.analytics.Yodo1MasSensorHelper;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasBannerAdapterBase;

import androidx.annotation.NonNull;

public class Yodo1MasMyTargetBannerAdapter extends Yodo1MasBannerAdapterBase {

    private MyTargetView bannerAd;
    private String currentBannerId;

    @Override
    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return bannerAd != null && bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (relateAdapter == null || !relateAdapter.isInitSDK()) {
            return;
        }

        Yodo1MasAdapterBase.AdId adId = getBannerAdId();

        if (bannerAd == null) {
            bannerAd = new MyTargetView(activity);
            bannerAd.setListener(bannerListener);
        }
        if (adId != null && !TextUtils.isEmpty(adId.adId) && !adId.adId.equals(currentBannerId)) {
            bannerAd.setSlotId(Integer.parseInt(adId.adId));
            currentBannerId = adId.adId;
        }
        if (bannerAd != null && bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Log.d(TAG, message);
            bannerAd.load();
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    @Override
    public View getBannerView() {
        return bannerAd;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                bannerAd.destroy();
                bannerAd = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return false;
    }


    private final MyTargetView.MyTargetViewListener bannerListener = new MyTargetView.MyTargetViewListener() {
        @Override
        public void onLoad(@NonNull MyTargetView myTargetView) {
            String message = "method: onLoad, banner: " + myTargetView.getAdSource();
            Log.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.SUCCESS);
            callback(Yodo1MasAdEvent.CODE_LOADED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");
        }

        @Override
        public void onNoAd(@NonNull String reason, @NonNull MyTargetView myTargetView) {
            String message = "method: onNoAd, banner: " + myTargetView.getAdSource() + "reason: " + reason;
            Log.d(TAG, message);
            trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.FAIL);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callback(error, Yodo1Mas.AdType.Banner);

            nextBanner();
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            loadBannerAdvertDelayed();
        }

        @Override
        public void onShow(@NonNull MyTargetView myTargetView) {
            String message = "method: onLoggingImpression, banner: " + myTargetView.getAdSource();
            Log.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            callback(Yodo1MasAdEvent.CODE_OPENED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");
        }

        @Override
        public void onClick(@NonNull MyTargetView myTargetView) {
            String message = "method: onClick, banner: " + myTargetView.getAdSource();
            Log.d(TAG, message);
        }
    };
}
