/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.mytarget;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.ads.InterstitialAd;
import com.my.target.ads.Reward;
import com.my.target.ads.RewardedAd;
import com.my.target.common.MyTargetPrivacy;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.mediation.mytarget.Yodo1MasMyTargetBannerAdapter;
import org.json.JSONObject;

public class Yodo1MasMyTargetAdapter
extends Yodo1MasAdapterBase {
    private RewardedAd rewardAd;
    private String currentRewardId;
    private Yodo1MasAdapterBase.AdvertState rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
    private final RewardedAd.RewardedAdListener rewardListener = new RewardedAd.RewardedAdListener(){

        public void onLoad(@NonNull RewardedAd rewardedAd) {
            String message = "method: onLoad, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.rewardState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasMyTargetAdapter.this.trackAdRequestSuccessed(Yodo1Mas.AdType.Reward);
        }

        public void onNoAd(@NonNull String reason, @NonNull RewardedAd rewardedAd) {
            String message = "method: onNoAd, reward: " + rewardedAd.getAdSource() + ", reason: " + reason;
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasMyTargetAdapter.this.trackAdRequestFailed(Yodo1Mas.AdType.Reward, null, reason);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasMyTargetAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
            Yodo1MasMyTargetAdapter.this.nextReward();
            Yodo1MasMyTargetAdapter.this.loadRewardAdvertDelayed();
        }

        public void onDisplay(@NonNull RewardedAd rewardedAd) {
            String message = "method: onDisplay, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.callback(1001, Yodo1Mas.AdType.Reward, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
        }

        public void onClick(@NonNull RewardedAd rewardedAd) {
            String message = "method: onClick, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
        }

        public void onDismiss(@NonNull RewardedAd rewardedAd) {
            String message = "method: onDismiss, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.callback(1002, Yodo1Mas.AdType.Reward, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasMyTargetAdapter.this.loadRewardAdvert();
        }

        public void onReward(@NonNull Reward reward, @NonNull RewardedAd rewardedAd) {
            String message = "method: onReward, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.callback(2001, Yodo1Mas.AdType.Reward, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
        }
    };
    private InterstitialAd interstitialAd;
    private String currentInterstitialId;
    private Yodo1MasAdapterBase.AdvertState interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
    private final InterstitialAd.InterstitialAdListener interstitialListener = new InterstitialAd.InterstitialAdListener(){

        public void onLoad(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onLoad, interstitial: " + interstitialAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.interstitialState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasMyTargetAdapter.this.trackAdRequestSuccessed(Yodo1Mas.AdType.Interstitial);
        }

        public void onNoAd(@NonNull String reason, @NonNull InterstitialAd interstitialAd) {
            String message = "method: onNoAd, interstitial: " + interstitialAd.getAdSource() + ", reason: " + reason;
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasMyTargetAdapter.this.trackAdRequestFailed(Yodo1Mas.AdType.Interstitial, null, reason);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasMyTargetAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
            Yodo1MasMyTargetAdapter.this.nextInterstitial();
            Yodo1MasMyTargetAdapter.this.loadInterstitialAdvertDelayed();
        }

        public void onDisplay(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onDisplay, interstitial: " + interstitialAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.callback(1001, Yodo1Mas.AdType.Interstitial, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
        }

        public void onClick(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onClick, interstitial: " + interstitialAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
        }

        public void onDismiss(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onDismiss, interstitial: " + interstitialAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetAdapter.this.callback(1002, Yodo1Mas.AdType.Interstitial, Yodo1MasMyTargetAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasMyTargetAdapter.this.loadInterstitialAdvert();
        }

        public void onVideoCompleted(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onVideoCompleted, interstitial: " + interstitialAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetAdapter.this.TAG, (String)message);
        }
    };

    public static void setMyTargetPrivacy() {
        MyTargetPrivacy.setUserConsent((boolean)Yodo1MasHelper.getInstance().isGDPRUserConsent());
        MyTargetPrivacy.setCcpaUserConsent((!Yodo1MasHelper.getInstance().isCCPADoNotSell() ? 1 : 0) != 0);
        MyTargetPrivacy.setUserAgeRestricted((boolean)Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
    }

    public String getAdvertCode() {
        return "mytarget";
    }

    public String getSDKVersion() {
        return "5.15.0";
    }

    public String getMediationVersion() {
        return "4.6.5";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            this.updatePrivacy();
            this.loadRewardAdvert();
            this.loadInterstitialAdvert();
        }
        if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        Yodo1MasMyTargetAdapter.setMyTargetPrivacy();
    }

    public boolean isRewardAdvertLoaded() {
        super.isRewardAdvertLoaded();
        return this.rewardAd != null && this.rewardState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getRewardAdId();
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || this.rewardAd != null && adId.adId.equals(this.currentRewardId))) {
            this.rewardAd = new RewardedAd(Integer.parseInt(adId.adId), (Context)activity);
            this.rewardAd.setListener(this.rewardListener);
            this.currentRewardId = adId.adId;
        }
        if (this.rewardAd != null && this.rewardState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardAd.load();
            this.rewardState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardAd.show();
            this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
        }
    }

    public void dismissRewardAdvert() {
        super.dismissRewardAdvert();
        if (this.rewardAd != null) {
            this.rewardAd.dismiss();
        }
        this.rewardAd = null;
        this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
    }

    public boolean isInterstitialAdvertLoaded() {
        super.isInterstitialAdvertLoaded();
        return this.interstitialAd != null && this.interstitialState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadInterstitialAdvert(@NonNull Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getInterstitialAdId();
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || this.interstitialAd != null && adId.adId.equals(this.currentInterstitialId))) {
            this.interstitialAd = new InterstitialAd(Integer.parseInt(adId.adId), (Context)activity);
            this.interstitialAd.setListener(this.interstitialListener);
            this.currentInterstitialId = adId.adId;
        }
        if (this.interstitialAd != null && this.interstitialState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadInterstitialAdvert, loading interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            this.interstitialAd.load();
            this.interstitialState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            this.interstitialAd.show();
            this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
        }
    }

    public void dismissInterstitialAdvert() {
        super.dismissInterstitialAdvert();
        if (this.interstitialAd != null) {
            this.interstitialAd.dismiss();
        }
        this.interstitialAd = null;
        this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
    }

    public Yodo1MasBannerAdapterBase getYodo1MasBannerAdapter() {
        Yodo1MasMyTargetBannerAdapter bannerAdapter = new Yodo1MasMyTargetBannerAdapter();
        bannerAdapter.bannerAdIds.clear();
        bannerAdapter.bannerAdIds.addAll(this.bannerAdIds);
        bannerAdapter.relateAdapter = this;
        bannerAdapter.advertCode = this.getAdvertCode();
        bannerAdapter.sdkVersion = this.getSDKVersion();
        bannerAdapter.mediationVersion = this.getMediationVersion();
        return bannerAdapter;
    }

    public void onActivityDestroy(@NonNull Activity activity) {
        super.onActivityDestroy(activity);
    }
}

