/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.mytarget;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import com.my.target.ads.MyTargetView;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasBannerAdapterBase;

public class Yodo1MasMyTargetBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private final MyTargetView.MyTargetViewListener bannerListener = new MyTargetView.MyTargetViewListener(){

        public void onLoad(@NonNull MyTargetView myTargetView) {
            String message = "method: onLoad, banner: " + myTargetView.getAdSource();
            Log.d((String)Yodo1MasMyTargetBannerAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasMyTargetBannerAdapter.this.trackAdRequestSuccessed();
            Yodo1MasMyTargetBannerAdapter.this.callback(1003, Yodo1MasMyTargetBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasMyTargetBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
            Yodo1MasMyTargetBannerAdapter.this.callbackAdapterState();
        }

        public void onNoAd(@NonNull String reason, @NonNull MyTargetView myTargetView) {
            String message = "method: onNoAd, banner: " + myTargetView.getAdSource() + "reason: " + reason;
            Log.d((String)Yodo1MasMyTargetBannerAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetBannerAdapter.this.trackAdRequestFailed(null, reason);
            Yodo1MasMyTargetBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            if (Yodo1MasMyTargetBannerAdapter.this.isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasMyTargetBannerAdapter.this.TAG + ":{" + message + "}");
                Yodo1MasMyTargetBannerAdapter.this.callback(error);
                Yodo1MasMyTargetBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
                Yodo1MasMyTargetBannerAdapter.this.callbackAdapterState();
            } else {
                Yodo1MasMyTargetBannerAdapter.this.nextBanner();
                Yodo1MasMyTargetBannerAdapter.this.loadBannerAdvertDelayed();
            }
        }

        public void onShow(@NonNull MyTargetView myTargetView) {
            String message = "method: onLoggingImpression, banner: " + myTargetView.getAdSource();
            Log.d((String)Yodo1MasMyTargetBannerAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasMyTargetBannerAdapter.this.callback(1001, Yodo1MasMyTargetBannerAdapter.this.TAG + ":{" + message + "}");
        }

        public void onClick(@NonNull MyTargetView myTargetView) {
            String message = "method: onClick, banner: " + myTargetView.getAdSource();
            Log.d((String)Yodo1MasMyTargetBannerAdapter.this.TAG, (String)message);
        }
    };
    private MyTargetView bannerAd;
    private String currentBannerId;

    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return this.bannerAd != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (this.relateAdapter == null || !this.relateAdapter.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (adId == null || TextUtils.isEmpty((CharSequence)adId.adId)) {
            return;
        }
        if (adId.object != null && !this.isPriceValuable(adId)) {
            this.handlePricyNotAbaliable();
            return;
        }
        if (this.bannerAd == null) {
            this.bannerAd = new MyTargetView((Context)activity);
            this.bannerAd.setListener(this.bannerListener);
        }
        if (!adId.adId.equals(this.currentBannerId)) {
            this.bannerAd.setSlotId(Integer.parseInt(adId.adId));
            this.currentBannerId = adId.adId;
        }
        if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Log.d((String)this.TAG, (String)message);
            this.bannerAd.load();
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADING;
            this.logAdIdInfo(adId);
        }
    }

    public View getBannerView() {
        return this.bannerAd;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            this.bannerAd.destroy();
            this.bannerAd = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return false;
    }
}

