/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.mytarget;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.my.target.ads.Reward;
import com.my.target.ads.RewardedAd;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import java.util.List;

public class Yodo1MasMyTargetRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private RewardedAd rewardAd;
    private final RewardedAd.RewardedAdListener rewardListener = new RewardedAd.RewardedAdListener(){

        public void onLoad(@NonNull RewardedAd rewardedAd) {
            String message = "method: onLoad, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetRewardAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetRewardAdapter.this.callbackLoad();
        }

        public void onNoAd(@NonNull String reason, @NonNull RewardedAd rewardedAd) {
            String message = "method: onNoAd, reward: " + rewardedAd.getAdSource() + ", reason: " + reason;
            Log.d((String)Yodo1MasMyTargetRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasMyTargetRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasMyTargetRewardAdapter.this.callbackError(error, 0, reason);
        }

        public void onDisplay(@NonNull RewardedAd rewardedAd) {
            String message = "method: onDisplay, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetRewardAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetRewardAdapter.this.callbackOpen();
        }

        public void onDismiss(@NonNull RewardedAd rewardedAd) {
            String message = "method: onDismiss, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetRewardAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetRewardAdapter.this.callbackClose();
        }

        public void onClick(@NonNull RewardedAd rewardedAd) {
            String message = "method: onClick, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetRewardAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetRewardAdapter.this.callbackClick();
        }

        public void onReward(@NonNull Reward reward, @NonNull RewardedAd rewardedAd) {
            String message = "method: onReward, reward: " + rewardedAd.getAdSource();
            Log.d((String)Yodo1MasMyTargetRewardAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetRewardAdapter.this.callbackEarned();
        }
    };

    public Yodo1MasMyTargetRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isRewardAdLoaded() {
        return this.rewardAd != null && super.isRewardAdLoaded();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Log.d((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.rewardAd = new RewardedAd(Integer.parseInt(adId), (Context)activity);
        this.rewardAd.setListener(this.rewardListener);
        this.rewardAd.load();
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardAd.show();
        }
    }

    public void destroy() {
        super.destroy();
        if (this.rewardAd != null) {
            this.rewardAd.dismiss();
        }
        this.rewardAd = null;
    }
}

