package com.yodo1.mas.mediation.mytarget;

import android.app.Activity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.my.target.common.MyTargetPrivacy;
import com.my.target.common.MyTargetVersion;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

public class Yodo1MasMyTargetAdapter extends Yodo1MasAdapterBase {

    public static void setMyTargetPrivacy() {
        MyTargetPrivacy.setUserConsent(Yodo1MasHelper.getInstance().isGDPRUserConsent());
        MyTargetPrivacy.setCcpaUserConsent(!Yodo1MasHelper.getInstance().isCCPADoNotSell());
        MyTargetPrivacy.setUserAgeRestricted(Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
    }

    @Override
    public String getAdvertCode() {
        return "mytarget";
    }

    @Override
    public String getSDKVersion() {
        return MyTargetVersion.VERSION;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!isInitSDK()) {
            init = true;
            updatePrivacy();
        }
        if (callback != null) {
            callback.onAdapterInitSuccessful(getAdvertCode());
        }
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        setMyTargetPrivacy();
    }

    // Reward
    @Override
    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasMyTargetRewardAdapter.class;
    }

    // Interstitial
    @Override
    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasMyTargetInterstitialAdapter.class;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasMyTargetBannerAdapter.class;
    }

    @Override
    public void onActivityDestroy(@NonNull Activity activity) {
        super.onActivityDestroy(activity);
    }
}
