/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.mytarget;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.my.target.ads.InterstitialAd;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.List;

public class Yodo1MasMyTargetInterstitialAdapter
extends Yodo1MasInterstitialAdapterBase {
    private InterstitialAd interstitialAd;
    private final InterstitialAd.InterstitialAdListener interstitialListener = new InterstitialAd.InterstitialAdListener(){

        public void onLoad(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onLoad, interstitial: " + interstitialAd.getAdSource();
            Yodo1MasLog.v((String)Yodo1MasMyTargetInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetInterstitialAdapter.this.callbackLoad();
        }

        public void onNoAd(@NonNull String reason, @NonNull InterstitialAd interstitialAd) {
            String message = "method: onNoAd, interstitial: " + interstitialAd.getAdSource() + ", reason: " + reason;
            Yodo1MasLog.v((String)Yodo1MasMyTargetInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasMyTargetInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasMyTargetInterstitialAdapter.this.callbackError(error, 0, reason);
        }

        public void onDisplay(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onDisplay, interstitial: " + interstitialAd.getAdSource();
            Yodo1MasLog.v((String)Yodo1MasMyTargetInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetInterstitialAdapter.this.callbackOpen();
        }

        public void onDismiss(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onDismiss, interstitial: " + interstitialAd.getAdSource();
            Yodo1MasLog.v((String)Yodo1MasMyTargetInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetInterstitialAdapter.this.callbackClose();
        }

        public void onClick(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onClick, interstitial: " + interstitialAd.getAdSource();
            Yodo1MasLog.v((String)Yodo1MasMyTargetInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasMyTargetInterstitialAdapter.this.callbackClick();
        }

        public void onVideoCompleted(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onVideoCompleted, interstitial: " + interstitialAd.getAdSource();
            Yodo1MasLog.v((String)Yodo1MasMyTargetInterstitialAdapter.this.TAG, (String)message);
        }
    };

    public Yodo1MasMyTargetInterstitialAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isInterstitialAdLoaded() {
        return this.interstitialAd != null && super.isInterstitialAdLoaded();
    }

    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.v((String)this.TAG, (String)message);
        this.interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.interstitialAd = new InterstitialAd(Integer.parseInt(adId), (Context)activity);
        this.interstitialAd.setListener(this.interstitialListener);
        this.interstitialAd.load();
    }

    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (this.isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.v((String)this.TAG, (String)message);
            this.interstitialAd.show();
        }
    }

    public void destroy() {
        super.destroy();
        if (this.interstitialAd != null) {
            this.interstitialAd.dismiss();
        }
        this.interstitialAd = null;
    }
}

