package com.yodo1.mas.mediation.mytarget;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.my.target.ads.Reward;
import com.my.target.ads.RewardedAd;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

import java.util.List;

public class Yodo1MasMyTargetRewardAdapter extends Yodo1MasRewardAdapterBase {
    private final RewardedAd.RewardedAdListener rewardListener = new RewardedAd.RewardedAdListener() {
        @Override
        public void onLoad(@NonNull RewardedAd rewardedAd) {
            String message = "method: onLoad, reward: " + rewardedAd.getAdSource();
            Yodo1MasLog.v(TAG, message);
            callbackLoad();
        }

        @Override
        public void onNoAd(@NonNull String reason, @NonNull RewardedAd rewardedAd) {
            String message = "method: onNoAd, reward: " + rewardedAd.getAdSource() + ", reason: " + reason;
            Yodo1MasLog.v(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, 0, reason);
        }

        @Override
        public void onDisplay(@NonNull RewardedAd rewardedAd) {
            String message = "method: onDisplay, reward: " + rewardedAd.getAdSource();
            Yodo1MasLog.v(TAG, message);
            callbackOpen();
        }

        @Override
        public void onDismiss(@NonNull RewardedAd rewardedAd) {
            String message = "method: onDismiss, reward: " + rewardedAd.getAdSource();
            Yodo1MasLog.v(TAG, message);
            callbackClose();
        }

        @Override
        public void onClick(@NonNull RewardedAd rewardedAd) {
            String message = "method: onClick, reward: " + rewardedAd.getAdSource();
            Yodo1MasLog.v(TAG, message);
            callbackClick();
        }

        @Override
        public void onReward(@NonNull Reward reward, @NonNull RewardedAd rewardedAd) {
            String message = "method: onReward, reward: " + rewardedAd.getAdSource();
            Yodo1MasLog.v(TAG, message);
            callbackEarned();
        }
    };
    private RewardedAd rewardAd;

    public Yodo1MasMyTargetRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && super.isRewardAdLoaded();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.v(TAG, message);

        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        rewardAd = new RewardedAd(Integer.parseInt(adId), activity);
        rewardAd.setListener(rewardListener);
        rewardAd.load();
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.v(TAG, message);
            rewardAd.show();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (rewardAd != null) {
            rewardAd.dismiss();
        }
        rewardAd = null;
    }
}
