package com.yodo1.mas.mediation.mytarget;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.my.target.ads.InterstitialAd;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasMyTargetInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private final InterstitialAd.InterstitialAdListener interstitialListener = new InterstitialAd.InterstitialAdListener() {
        @Override
        public void onLoad(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onLoad, interstitial: " + interstitialAd.getAdSource();
            Yodo1MasLog.d(TAG, message);
            callbackLoad();
        }

        @Override
        public void onNoAd(@NonNull String reason, @NonNull InterstitialAd interstitialAd) {
            String message = "method: onNoAd, interstitial: " + interstitialAd.getAdSource() + ", reason: " + reason;
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, 0, reason);
        }

        @Override
        public void onDisplay(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onDisplay, interstitial: " + interstitialAd.getAdSource();
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onDismiss(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onDismiss, interstitial: " + interstitialAd.getAdSource();
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onClick(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onClick, interstitial: " + interstitialAd.getAdSource();
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }

        @Override
        public void onVideoCompleted(@NonNull InterstitialAd interstitialAd) {
            String message = "method: onVideoCompleted, interstitial: " + interstitialAd.getAdSource();
            Yodo1MasLog.d(TAG, message);
        }
    };
    private InterstitialAd interstitialAd;

    public Yodo1MasMyTargetInterstitialAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && super.isInterstitialAdLoaded();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d(TAG, message);

        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        interstitialAd = new InterstitialAd(Integer.parseInt(adId), activity);
        interstitialAd.setListener(interstitialListener);
        interstitialAd.load();
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);
            interstitialAd.show();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (interstitialAd != null) {
            interstitialAd.dismiss();
        }
        interstitialAd = null;
    }
}
