/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.pangle;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdConfig;
import com.bytedance.sdk.openadsdk.TTAdDislike;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTFullScreenVideoAd;
import com.bytedance.sdk.openadsdk.TTNativeExpressAd;
import com.bytedance.sdk.openadsdk.TTRewardVideoAd;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasBanner;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import java.util.List;
import org.json.JSONObject;

public class Yodo1MasPangleAdapter
extends Yodo1MasAdapterBase {
    private TTAdNative mTTAdNative;
    private TTRewardVideoAd mttRewardVideoAd;
    private TTFullScreenVideoAd mttFullVideoAd;
    private TTNativeExpressAd nativeExpressAd;
    private View bannerView;
    private Yodo1MasAdapterBase.AdvertState rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
    private Yodo1MasAdapterBase.AdvertState interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
    private String currentRewardId;
    private String currentInterstitialId;
    private String currentBannerId;
    private Activity activity;
    boolean isAddBannerView = false;
    private TTAdNative.RewardVideoAdListener rewardAdLister = new TTAdNative.RewardVideoAdListener(){

        public void onError(int code, String message) {
            String msg = "method: onError, code: " + code + ", message: " + message;
            Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)msg);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasPangleAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasPangleAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
            Yodo1MasPangleAdapter.this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasPangleAdapter.this.nextReward();
            Yodo1MasPangleAdapter.this.loadRewardAdvertDelayed();
        }

        public void onRewardVideoAdLoad(TTRewardVideoAd ttRewardVideoAd) {
            YLog.d((String)(Yodo1MasPangleAdapter.this.TAG + "RewardVideoAd onRewardVideoAdLoad"));
            Yodo1MasPangleAdapter.this.mttRewardVideoAd = ttRewardVideoAd;
            Yodo1MasPangleAdapter.this.mttRewardVideoAd.setRewardAdInteractionListener(new TTRewardVideoAd.RewardAdInteractionListener(){

                public void onAdShow() {
                    String message = "method: onAdDisplayed";
                    Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                    Yodo1MasPangleAdapter.this.callback(1001, Yodo1Mas.AdType.Reward, Yodo1MasPangleAdapter.this.TAG + ":{" + message + "}");
                }

                public void onAdVideoBarClick() {
                    String message = "method: onAdVideoBarClick ";
                    Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                }

                public void onAdClose() {
                    String message = "method: onAdClose";
                    Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                    Yodo1MasPangleAdapter.this.callback(1002, Yodo1Mas.AdType.Reward, Yodo1MasPangleAdapter.this.TAG + ":{" + message + "}");
                    Yodo1MasPangleAdapter.this.loadRewardAdvert();
                }

                public void onVideoComplete() {
                    String message = "method: onVideoComplete";
                    Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                }

                public void onVideoError() {
                    String message = "method: onVideoError";
                    Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                    Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasPangleAdapter.this.TAG + ":{" + message + "}");
                    Yodo1MasPangleAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
                    Yodo1MasPangleAdapter.this.nextReward();
                    Yodo1MasPangleAdapter.this.loadRewardAdvert();
                }

                public void onRewardVerify(boolean rewardVerify, int rewardAmount, String rewardName) {
                    String message = "RewardVideoAd onRewardVerify, rewardVerify: " + rewardVerify + ", rewardAmount:" + rewardAmount + ", rewardName:" + rewardName;
                    Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                    Yodo1MasPangleAdapter.this.callback(2001, Yodo1Mas.AdType.Reward, Yodo1MasPangleAdapter.this.TAG + ":{" + message + "}");
                }

                public void onSkippedVideo() {
                    YLog.d((String)(Yodo1MasPangleAdapter.this.TAG + "RewardVideoAd onSkippedVideo"));
                }
            });
        }

        public void onRewardVideoCached() {
            String message = "method: onLoad, reward: onRewardVideoCached";
            Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
            Yodo1MasPangleAdapter.this.rewardState = Yodo1MasAdapterBase.AdvertState.LOADED;
        }
    };
    private TTAdNative.FullScreenVideoAdListener interstitialListener = new TTAdNative.FullScreenVideoAdListener(){

        public void onError(int code, String message) {
            String msg = "method: onError, code: " + code + ", message: " + message;
            Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)msg);
            Yodo1MasPangleAdapter.this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasPangleAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasPangleAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
            Yodo1MasPangleAdapter.this.nextInterstitial();
            Yodo1MasPangleAdapter.this.loadInterstitialAdvertDelayed();
        }

        public void onFullScreenVideoAdLoad(TTFullScreenVideoAd ttFullScreenVideoAd) {
            YLog.d((String)(Yodo1MasPangleAdapter.this.TAG + "FullScreenVideoAd onFullScreenVideoAdLoad"));
            Yodo1MasPangleAdapter.this.mttFullVideoAd = ttFullScreenVideoAd;
            Yodo1MasPangleAdapter.this.mttFullVideoAd.setFullScreenVideoAdInteractionListener(new TTFullScreenVideoAd.FullScreenVideoAdInteractionListener(){

                public void onAdShow() {
                    String message = "method:FullScreenVideoAd onAdShow: ";
                    Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                    Yodo1MasPangleAdapter.this.callback(1001, Yodo1Mas.AdType.Interstitial, Yodo1MasPangleAdapter.this.TAG + ":{" + message + "}");
                }

                public void onAdVideoBarClick() {
                    String message = "method: FullScreenVideoAd onAdVideoBarClick: ";
                    Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                }

                public void onAdClose() {
                    String message = "method: FullScreenVideoAd, onAdClose: ";
                    Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                    Yodo1MasPangleAdapter.this.callback(1002, Yodo1Mas.AdType.Interstitial, Yodo1MasPangleAdapter.this.TAG + ":{" + message + "}");
                    Yodo1MasPangleAdapter.this.loadInterstitialAdvert();
                }

                public void onVideoComplete() {
                    String message = "method: FullScreenVideoAd onVideoComplete: ";
                    Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                }

                public void onSkippedVideo() {
                    String message = "method: FullScreenVideoAd onSkippedVideo: ";
                    Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                }
            });
        }

        public void onFullScreenVideoCached() {
            String message = "method: FullScreenVideoAd";
            Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
            Yodo1MasPangleAdapter.this.interstitialState = Yodo1MasAdapterBase.AdvertState.LOADED;
        }
    };
    private TTAdNative.NativeExpressAdListener nativeExpressAdListener = new TTAdNative.NativeExpressAdListener(){

        public void onError(int i, String s) {
            String message = "method: NativeExpressAdListener onError, banner: i: " + i + " s: " + s;
            Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasPangleAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasPangleAdapter.this.callback(error, Yodo1Mas.AdType.Banner);
            Yodo1MasPangleAdapter.this.nextBanner();
            Yodo1MasPangleAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasPangleAdapter.this.loadBannerAdvertDelayed();
        }

        public void onNativeExpressAdLoad(List<TTNativeExpressAd> list) {
            if (list == null || list.size() == 0) {
                return;
            }
            Yodo1MasPangleAdapter.this.nativeExpressAd = list.get(0);
            if (Yodo1MasPangleAdapter.this.nativeExpressAd == null) {
                return;
            }
            String message = "method: onLoad, banner: ";
            Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
            Yodo1MasPangleAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasPangleAdapter.this.nativeExpressAd.setSlideIntervalTime(30000);
            Yodo1MasPangleAdapter.this.bindAdListener(Yodo1MasPangleAdapter.this.nativeExpressAd);
            Yodo1MasPangleAdapter.this.nativeExpressAd.render();
        }
    };

    public String getAdvertCode() {
        return "pangle";
    }

    public String getSDKVersion() {
        return "3.4.1.1";
    }

    public String getMediationVersion() {
        return "4.1.0";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (this.isInitSDK()) {
            if (callback != null) {
                callback.onAdapterInitSuccessful(this.getAdvertCode());
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)config.appId)) {
            if (callback != null) {
                callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
            }
            return;
        }
        this.activity = activity;
        this.init = true;
        TTAdSdk.init((Context)activity, (TTAdConfig)Yodo1MasPangleAdapter.buildConfig((Context)activity, config.appId));
        this.mTTAdNative = TTAdSdk.getAdManager().createAdNative((Context)activity);
        this.updatePrivacy();
        this.loadRewardAdvert();
        this.loadInterstitialAdvert();
        this.loadBannerAdvert();
        if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    private static TTAdConfig buildConfig(Context context, String appId) {
        return new TTAdConfig.Builder().appId(appId).useTextureView(true).appName(SysUtils.getAppName((Context)context)).titleBarTheme(1).allowShowPageWhenScreenLock(true).debug(false).coppa(Yodo1MasHelper.getInstance().isCOPPAAgeRestricted() ? 1 : 0).setGDPR(Yodo1MasHelper.getInstance().isGDPRUserConsent() ? 1 : 0).supportMultiProcess(false).build();
    }

    public void updatePrivacy() {
        super.updatePrivacy();
    }

    public boolean isRewardAdvertLoaded() {
        super.isRewardAdvertLoaded();
        return this.mttRewardVideoAd != null && this.rewardState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getRewardAdId();
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || this.mttRewardVideoAd != null && adId.adId.equals(this.currentRewardId) || this.rewardState == Yodo1MasAdapterBase.AdvertState.LOADING)) {
            AdSlot adSlot = new AdSlot.Builder().setCodeId(adId.adId).setSupportDeepLink(true).setImageAcceptedSize(1080, 1920).build();
            this.mTTAdNative.loadRewardVideoAd(adSlot, this.rewardAdLister);
            this.currentRewardId = adId.adId;
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (this.mttRewardVideoAd != null && this.isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.mttRewardVideoAd.showRewardVideoAd(activity);
            this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
        }
    }

    public void dismissRewardAdvert() {
        super.dismissRewardAdvert();
        this.mttRewardVideoAd = null;
    }

    public boolean isInterstitialAdvertLoaded() {
        super.isInterstitialAdvertLoaded();
        return this.mttFullVideoAd != null && this.interstitialState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadInterstitialAdvert(@NonNull Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getInterstitialAdId();
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || this.mttFullVideoAd != null && adId.adId.equals(this.currentInterstitialId))) {
            int orientation = activity.getResources().getConfiguration().orientation == 1 ? 1 : 2;
            AdSlot adSlot = new AdSlot.Builder().setCodeId(adId.adId).setSupportDeepLink(true).setImageAcceptedSize(1080, 1920).setOrientation(orientation).build();
            this.mTTAdNative.loadFullScreenVideoAd(adSlot, this.interstitialListener);
            this.currentInterstitialId = adId.adId;
            String message = "method: loadInterstitialAdvert, loading interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            this.interstitialState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            if (this.mttFullVideoAd != null) {
                this.mttFullVideoAd.showFullScreenVideoAd(activity);
            }
            this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
        }
    }

    public void dismissInterstitialAdvert() {
        super.dismissInterstitialAdvert();
        this.mttFullVideoAd = null;
    }

    public boolean isBannerAdvertLoaded() {
        return this.bannerView != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && !adId.adId.equals(this.currentBannerId)) {
            this.currentBannerId = adId.adId;
            AdSlot adSlot = new AdSlot.Builder().setCodeId(adId.adId).setSupportDeepLink(true).setAdCount(1).setExpressViewAcceptedSize(320.0f, 50.0f).build();
            if (this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
                String message = "method: loadBannerAdvert, loading banner ad...";
                Log.d((String)this.TAG, (String)message);
                this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
                this.mTTAdNative.loadBannerExpressAd(adSlot, this.nativeExpressAdListener);
            }
        }
    }

    public void showBannerAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showBannerAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Banner, callback)) {
            String message = "method: showBannerAdvert, show banner ad...";
            Log.d((String)this.TAG, (String)message);
            if (!this.isAddBannerView) {
                this.isAddBannerView = true;
                Yodo1MasBanner.showBanner((Activity)activity, (View)this.bannerView, (JSONObject)object);
            }
        }
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerView != null) {
            Yodo1MasBanner.removeBanner((View)this.bannerView);
            if (destroy) {
                this.bannerView = null;
                this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                this.loadBannerAdvert();
            }
        }
    }

    public void onActivityDestroy(@NonNull Activity activity) {
        super.onActivityDestroy(activity);
        if (this.nativeExpressAd != null) {
            this.nativeExpressAd.destroy();
            this.nativeExpressAd = null;
        }
    }

    private void bindAdListener(TTNativeExpressAd nativeExpressAd) {
        nativeExpressAd.setExpressInteractionListener(new TTNativeExpressAd.ExpressAdInteractionListener(){

            public void onAdClicked(View bannerView, int type) {
                String message = "method: onAdClicked, banner: type: " + type;
                Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
            }

            public void onAdShow(View bannerView, int type) {
                String message = "method: onLoggingImpression, banner: ";
                Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                Yodo1MasPangleAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                Yodo1MasPangleAdapter.this.callback(1001, Yodo1Mas.AdType.Banner, Yodo1MasPangleAdapter.this.TAG + ":{" + message + "}");
            }

            public void onRenderFail(View bannerView, String msg, int code) {
                String message = "method: onRenderFail, banner: msg: " + msg + ", code: " + code;
                Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
            }

            public void onRenderSuccess(View bannerView, float width, float height) {
                String message = "method: onRenderFail, banner: width: " + width + ", height: " + height;
                Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                Yodo1MasPangleAdapter.this.bannerView = bannerView;
            }
        });
        nativeExpressAd.setDislikeCallback(this.activity, new TTAdDislike.DislikeInteractionCallback(){

            public void onSelected(int position, String value) {
                String message = "method: onSelected, banner: position: " + position + ", value: " + value;
                Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
                Yodo1MasPangleAdapter.this.dismissBannerAdvert(false);
            }

            public void onCancel() {
                String message = "method: onCancel, banner: ";
                Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
            }

            public void onRefuse() {
                String message = "method: onRefuse, banner: ";
                Log.d((String)Yodo1MasPangleAdapter.this.TAG, (String)message);
            }
        });
    }
}

