package com.yodo1.mas.mediation.pangle;

import android.app.Activity;
import android.text.TextUtils;

import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialAd;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialAdLoadListener;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialRequest;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasPangleInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private final PAGInterstitialAdInteractionListener eventsListener = new PAGInterstitialAdInteractionListener() {

        @Override
        public void onAdShowed() {
            String message = "method: onAdShowed, interstitial";
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdClicked() {
            String message = "method: onAdClicked, interstitial";
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }

        @Override
        public void onAdDismissed() {
            String message = "method: onAdDismissed, interstitial";
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }
    };
    private PAGInterstitialRequest interstitialRequest;
    private PAGInterstitialAd interstitialAd;
    private final PAGInterstitialAdLoadListener interstitialListener = new PAGInterstitialAdLoadListener() {
        @Override
        public void onError(int code, String message) {
            String msg = "method: onError, code: " + code + ", message: " + message;
            Yodo1MasLog.d(TAG, msg);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            Yodo1MasAdRequestResultInfo adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, getAdUnitId(), false, getAdLoadDuration(), code+"", message);
            callbackError(error, code, message, adRequestResult);
        }

        @Override
        public void onAdLoaded(PAGInterstitialAd pagInterstitialAd) {
            Yodo1MasLog.d(TAG, "mehtod: onAdLoaded, interstitial");

            interstitialAd = pagInterstitialAd;
            interstitialAd.setAdInteractionListener(eventsListener);
            Yodo1MasAdRequestResultInfo adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, getAdUnitId(), true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

    };

    public Yodo1MasPangleInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && super.isInterstitialAdLoaded();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (interstitialRequest == null) {
            interstitialRequest = new PAGInterstitialRequest();
        }

        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d(TAG, message);
        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        PAGInterstitialAd.loadAd(adId, interstitialRequest, interstitialListener);
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);
            if (interstitialAd != null) {
                interstitialAd.show(activity);
            }
        }
    }
}
