package com.yodo1.mas.mediation.pangle;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.bytedance.sdk.openadsdk.api.reward.PAGRewardItem;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedAd;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedAdLoadListener;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedRequest;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasPangleRewardAdapter extends Yodo1MasRewardAdapterBase {

    private final PAGRewardedAdInteractionListener eventsListener = new PAGRewardedAdInteractionListener() {

        @Override
        public void onAdShowed() {
            String message = "method: onAdShowed, Reward";
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdClicked() {
            String message = "method: onAdClicked, Reward";
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }

        @Override
        public void onAdDismissed() {
            String message = "method: onAdDismissed, Reward";
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onUserEarnedReward(PAGRewardItem pagRewardItem) {
            String message = "RewardVideoAd onUserEarnedReward, rewardAmount: " + (pagRewardItem != null ? pagRewardItem.getRewardAmount() : null)
                    + ", rewardName:" + (pagRewardItem != null ? pagRewardItem.getRewardName() : null);
            Yodo1MasLog.d(TAG, message);
            callbackEarned();
        }

        @Override
        public void onUserEarnedRewardFail(int i, String s) {
            //TODO? which cause this method can callback，display faied or skip the playing video？ need to test
            String message = "method: onUserEarnedRewardFail, Reward i";
            Yodo1MasLog.d(TAG, message);
        }


//        @Override
//        public void onVideoError() {
//            String message = "method: onVideoError";
//            Yodo1MasLog.d(TAG, message);
//            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
//            callbackError(error, 0, "");
//        }
//
//        @Override
//        public void onRewardVerify(boolean rewardVerify, int rewardAmount, String rewardName, int errorCode, String errorMsg) {
//            String message = "RewardVideoAd onRewardVerify, rewardVerify: " + rewardVerify + ", rewardAmount:" + rewardAmount + ", rewardName:" + rewardName + ", errorCode:" + errorCode + ", errorMsg:" + errorMsg;
//            Yodo1MasLog.d(TAG, message);
//            callbackEarned();
//        }

    };
    protected PAGRewardedRequest rewardedRequest;
    private PAGRewardedAd rewardAd;
    private final PAGRewardedAdLoadListener rewardAdLister = new PAGRewardedAdLoadListener() {

        @Override
        public void onError(int code, String message) {
            String msg = "method: onError, code: " + code + ", message: " + message;
            Yodo1MasLog.d(TAG, msg);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            Yodo1MasAdRequestResultInfo adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, getAdUnitId(), false, getAdLoadDuration(), code + "", message);
            callbackError(error, code, message, adRequestResult);
        }

        @Override
        public void onAdLoaded(PAGRewardedAd pagRewardedAd) {
            Yodo1MasLog.d(TAG, "RewardVideoAd onRewardVideoAdLoad");
            rewardAd = pagRewardedAd;
            rewardAd.setAdInteractionListener(eventsListener);
            Yodo1MasAdRequestResultInfo adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, getAdUnitId(), true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }
    };

    public Yodo1MasPangleRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && super.isRewardAdLoaded();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (rewardedRequest == null) {
            rewardedRequest = new PAGRewardedRequest();
        }

        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d(TAG, message);

        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        PAGRewardedAd.loadAd(adId, rewardedRequest, rewardAdLister);
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d(TAG, message);
            if (rewardAd != null) {
                rewardAd.show(activity);
            }
        }
    }
}
