package com.yodo1.mas.mediation.pangle;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;

import androidx.annotation.NonNull;

import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAd;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdInteractionCallback;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdLoadListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerRequest;
import com.bytedance.sdk.openadsdk.api.model.PAGErrorModel;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasPangleBannerAdapter extends Yodo1MasBannerAdapterBase {
    private PAGBannerAd bannerAd;
    private String currentBannerId;
    private final PAGBannerAdLoadListener bannerListener = new PAGBannerAdLoadListener() {

        @Override
        public void onError(int i, String s) {
            String message = "method: NativeExpressAdListener onError, banner: i: " + i + " s: " + s;
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;

            if (isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
                callback(error);
                advertAdapterState = AdvertAdapterState.FAILED;
                callbackAdapterState();
            } else {
                nextBanner();
                loadBannerAdvertDelayed();
            }
        }

        @Override
        public void onAdLoaded(PAGBannerAd pagBannerAd) {
            String message = "method: onLoad, banner: ";
            Yodo1MasLog.d(TAG, message);

            bannerAd = pagBannerAd;
            bannerAd.setAdInteractionListener(bannerPlayListener);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            callback(Yodo1MasAdEvent.CODE_LOADED, TAG + ":{" + message + "}");

            advertAdapterState = AdvertAdapterState.LOADED;
            callbackAdapterState();

//            //- banner广告轮播的间隔时间，允许值在30s ~ 120s之间
//            nativeExpressAd.setSlideIntervalTime(30 * 1000);
//            bindAdListener(nativeExpressAd);
//            nativeExpressAd.render();
        }
    };

    private final PAGBannerAdInteractionListener bannerPlayListener = new PAGBannerAdInteractionCallback() {
        @Override
        public void onAdShowed() {
            String message = "method: onLoggingImpression, banner: ";
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            callback(Yodo1MasAdEvent.CODE_OPENED, TAG + ":{" + message + "}");
        }

        @Override
        public void onAdClicked() {
            String message = "method: onAdClicked ";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdDismissed() {
            String message = "method: onAdDismissed ";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdShowFailed(@NonNull PAGErrorModel pagErrorModel) {
            String message = "method: onRenderFail, banner: msg: " + pagErrorModel.getErrorMessage() + ", code: " + pagErrorModel.getErrorCode();
            Yodo1MasLog.d(TAG, message);
        }
    };

    public Yodo1MasPangleBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    @Override
    public boolean isBannerAdvertLoaded() {
        return bannerAd != null && bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (relateAdapter == null || !relateAdapter.isInitSDK()) {
            return;
        }

        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        if (adId != null && adId.object != null && !isPriceValuable(adId)) {
            handlePricyNotAbaliable();
            return;
        }

        if (adId != null && !TextUtils.isEmpty(adId.adId) && !adId.adId.equals(currentBannerId)) {
            currentBannerId = adId.adId;

//            AdSlot adSlot = new AdSlot.Builder()
//                    .setCodeId(adId.adId)
//                    .setSupportDeepLink(true)
//                    .setAdCount(1)
//                    .setExpressViewAcceptedSize(320, 50)
//                    .build();

            if (bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
                String message = "method: loadBannerAdvert, loading banner ad...";
                Yodo1MasLog.d(TAG, message);

                PAGBannerRequest bannerRequest = getBannerRequest();
                if (bannerRequest != null) {
                    bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
                    advertAdapterState = AdvertAdapterState.LOADING;
                    PAGBannerAd.loadAd(adId.adId, bannerRequest, bannerListener);
                    logAdIdInfo(adId);
                }
            }

        }
    }

    private PAGBannerRequest getBannerRequest() {
        if (relateAdapter != null && relateAdapter instanceof Yodo1MasPangleAdapter) {
            Yodo1MasPangleAdapter adapter = (Yodo1MasPangleAdapter) relateAdapter;
            return adapter.getBannerRequest();
        }
        return null;

    }

    @Override
    public View getBannerView() {
        return bannerAd != null ? bannerAd.getBannerView() : null;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                bannerAd.destroy();
                bannerAd = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                advertAdapterState = AdvertAdapterState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return false;
    }

}
