package com.yodo1.mas.mediation.pangle;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bytedance.sdk.openadsdk.api.PAGConstant;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerRequest;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerSize;
import com.bytedance.sdk.openadsdk.api.init.PAGConfig;
import com.bytedance.sdk.openadsdk.api.init.PAGSdk;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;
import com.yodo1.mas.utils.Yodo1MasUtils;

public class Yodo1MasPangleAdapter extends Yodo1MasAdapterBase {

    private PAGBannerRequest mBannerRequest;

    /**
     * Get PAGConfig
     * useTextureView: 使用TextureView控件播放视频,默认为SurfaceView,当有SurfaceView冲突的场景，可以使用TextureView
     * allowShowPageWhenScreenLock: 是否在锁屏场景支持展示广告落地页
     * debugLog: 测试阶段打开，可以通过日志排查问题，上线时去除该调用
     * setGDPR: Fields to indicate whether you are protected by GDPR,  the value of GDPR : 0 close GDRP Privacy protection ，1: open GDRP Privacy protection
     *
     * @param context Context
     * @param appId   App Id
     * @return PAGConfig
     */
    private static PAGConfig buildConfig(Context context, String appId) {
        int gdpr = Yodo1MasHelper.getInstance().isGDPRUserConsent() ?
                PAGConstant.PAGGDPRConsentType.PAG_GDPR_CONSENT_TYPE_CONSENT : PAGConstant.PAGGDPRConsentType.PAG_GDPR_CONSENT_TYPE_NO_CONSENT;

        int pa = (Yodo1MasHelper.getInstance().isCOPPAAgeRestricted() || Yodo1MasHelper.getInstance().isCCPADoNotSell()) ?
                PAGConstant.PAGPAConsentType.PAG_PA_CONSENT_TYPE_NO_CONSENT : PAGConstant.PAGPAConsentType.PAG_PA_CONSENT_TYPE_CONSENT;

        return new PAGConfig.Builder()
                .appId(appId)
                .useTextureView(true)
                .debugLog(false)
                .setGDPRConsent(gdpr)
                .setPAConsent(pa)
                .supportMultiProcess(false)
                .build();
    }

    @Override
    public String getAdvertCode() {
        return "pangle";
    }

    @Override
    public String networkName() {
        return "Pangle";
    }

    @Override
    public String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    public PAGBannerRequest getBannerRequest() {
        return mBannerRequest;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (isInitSDK()) {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
            return;
        }

        if (TextUtils.isEmpty(config.appId)) {
            if (callback != null) {
                callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, "config.appId is null"));
            }
            return;
        }

        init = true;

        PAGSdk.init(activity, buildConfig(activity, config.appId), new PAGSdk.PAGInitCallback() {
            @Override
            public void success() {
                String message = "method: success";
                Yodo1MasLog.d(TAG, message);
            }

            @Override
            public void fail(int i, String s) {
                String message = "method: fail, i: " + i + ", s: " + s;
                Yodo1MasLog.d(TAG, message);
            }
        });

        PAGBannerSize bannerSize = PAGBannerSize.BANNER_W_320_H_50;
        //PAGBannerSize bannerSize = new PAGBannerSize(320,50);
        mBannerRequest = new PAGBannerRequest(bannerSize);

        updatePrivacy();
        if (callback != null) {
            callback.onAdapterInitSuccessful(getAdvertCode());
        }
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
    }

    // Reward
    @Override
    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasPangleRewardAdapter.class;
    }

    // Interstitial
    @Override
    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasPangleInterstitialAdapter.class;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasPangleBannerAdapter.class;
    }

    // Rewarded Interstitial
    @Override
    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    // App Open
    @Override
    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}
