package com.yodo1.mas.mediation.pangle;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;

import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdDislike;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTNativeExpressAd;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasBannerAdapterBase;

import java.util.List;

import androidx.annotation.NonNull;

public class Yodo1MasPangleBannerAdapter extends Yodo1MasBannerAdapterBase {

    //    private TTAdNative mTTAdNative;
    private TTNativeExpressAd nativeExpressAd;
    private View bannerView;
    private String currentBannerId;
    boolean isAddBannerView = false;

    @Override
    public boolean isBannerAdvertLoaded() {
        return bannerView != null && bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (relateAdapter == null || !relateAdapter.isInitSDK()) {
            return;
        }

        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        if(adId != null && adId.object != null && !isPriceValuable(adId)) {
            handlePricyNotAbaliable();
            return;
        }

        if (adId != null && !TextUtils.isEmpty(adId.adId) && !adId.adId.equals(currentBannerId)) {
            currentBannerId = adId.adId;

            AdSlot adSlot = new AdSlot.Builder()
                    .setCodeId(adId.adId)
                    .setSupportDeepLink(true)
                    .setAdCount(1)
                    .setExpressViewAcceptedSize(320, 50)
                    .build();

            if (bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
                String message = "method: loadBannerAdvert, loading banner ad...";
                Log.d(TAG, message);

                TTAdNative ttAdNative = getTTAdNative();
                if (ttAdNative != null) {
                    bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
                    advertAdapterState = AdvertAdapterState.LOADING;
                    ttAdNative.loadBannerExpressAd(adSlot, nativeExpressAdListener);
                    logAdIdInfo(adId);
                }
            }

        }
    }

    private TTAdNative getTTAdNative() {
        if (relateAdapter != null && relateAdapter instanceof Yodo1MasPangleAdapter) {
            Yodo1MasPangleAdapter adapter = (Yodo1MasPangleAdapter) relateAdapter;
            return adapter.getTTAdNative();
        }
        return null;

    }

    @Override
    public View getBannerView() {
        return bannerView;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerView != null) {
            if (destroy) {
                bannerView = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                advertAdapterState = AdvertAdapterState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return false;
    }

    private TTAdNative.NativeExpressAdListener nativeExpressAdListener = new TTAdNative.NativeExpressAdListener() {

        @Override
        public void onError(int i, String s) {
            String message = "method: NativeExpressAdListener onError, banner: i: " + i + " s: " + s;
            Log.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;

            if(isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
                callback(error);
                advertAdapterState = AdvertAdapterState.FAILED;
                callbackAdapterState();
            }
            else {
                nextBanner();
                loadBannerAdvertDelayed();
            }
        }

        @Override
        public void onNativeExpressAdLoad(List<TTNativeExpressAd> list) {
            if (list == null || list.size() == 0) {
                return;
            }

            nativeExpressAd = list.get(0);
            if (nativeExpressAd == null) {
                return;
            }

            String message = "method: onLoad, banner: ";
            Log.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            callback(Yodo1MasAdEvent.CODE_LOADED, TAG + ":{" + message + "}");

            advertAdapterState = AdvertAdapterState.LOADED;
            callbackAdapterState();

            //- banner广告轮播的间隔时间，允许值在30s ~ 120s之间
            nativeExpressAd.setSlideIntervalTime(30 * 1000);
            bindAdListener(nativeExpressAd);
            nativeExpressAd.render();
        }
    };

    private void bindAdListener(TTNativeExpressAd nativeExpressAd) {
        nativeExpressAd.setExpressInteractionListener(new TTNativeExpressAd.ExpressAdInteractionListener() {
            @Override
            public void onAdClicked(View bannerView, int type) {
                String message = "method: onAdClicked, banner: type: " + type;
                Log.d(TAG, message);
            }

            @Override
            public void onAdShow(View bannerView, int type) {
                String message = "method: onLoggingImpression, banner: ";
                Log.d(TAG, message);
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                callback(Yodo1MasAdEvent.CODE_OPENED, TAG + ":{" + message + "}");
            }

            @Override
            public void onRenderFail(View bannerView, String msg, int code) {
                String message = "method: onRenderFail, banner: msg: " + msg + ", code: " + code;
                Log.d(TAG, message);
            }

            @Override
            public void onRenderSuccess(View bannerView, float width, float height) {
                String message = "method: onRenderFail, banner: width: " + width + ", height: " + height;
                Log.d(TAG, message);
                Yodo1MasPangleBannerAdapter.this.bannerView = bannerView;
            }
        });

        //dislike
        nativeExpressAd.setDislikeCallback(getCurrentActivity(), new TTAdDislike.DislikeInteractionCallback() {
            @Override
            public void onSelected(int position, String value) {
                //After ads user select dislink remove banner
                String message = "method: onSelected, banner: position: " + position + ", value: " + value;
                Log.d(TAG, message);
                dismissBannerAdvert(false);
            }

            @Override
            public void onCancel() {
                String message = "method: onCancel, banner: ";
                Log.d(TAG, message);
            }

            @Override
            public void onRefuse() {
                String message = "method: onRefuse, banner: ";
                Log.d(TAG, message);
            }
        });
    }
}
