/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.pangle;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdDislike;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTNativeExpressAd;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.pangle.Yodo1MasPangleAdapter;
import java.util.List;

public class Yodo1MasPangleBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private TTNativeExpressAd nativeExpressAd;
    private View bannerView;
    private String currentBannerId;
    boolean isAddBannerView = false;
    private TTAdNative.NativeExpressAdListener nativeExpressAdListener = new TTAdNative.NativeExpressAdListener(){

        public void onError(int i, String s) {
            String message = "method: NativeExpressAdListener onError, banner: i: " + i + " s: " + s;
            Log.d((String)Yodo1MasPangleBannerAdapter.this.TAG, (String)message);
            Yodo1MasPangleBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            if (Yodo1MasPangleBannerAdapter.this.isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasPangleBannerAdapter.this.TAG + ":{" + message + "}");
                Yodo1MasPangleBannerAdapter.this.callback(error);
                Yodo1MasPangleBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
                Yodo1MasPangleBannerAdapter.this.callbackAdapterState();
            } else {
                Yodo1MasPangleBannerAdapter.this.nextBanner();
                Yodo1MasPangleBannerAdapter.this.loadBannerAdvertDelayed();
            }
        }

        public void onNativeExpressAdLoad(List<TTNativeExpressAd> list) {
            if (list == null || list.size() == 0) {
                return;
            }
            Yodo1MasPangleBannerAdapter.this.nativeExpressAd = list.get(0);
            if (Yodo1MasPangleBannerAdapter.this.nativeExpressAd == null) {
                return;
            }
            String message = "method: onLoad, banner: ";
            Log.d((String)Yodo1MasPangleBannerAdapter.this.TAG, (String)message);
            Yodo1MasPangleBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasPangleBannerAdapter.this.callback(1003, Yodo1MasPangleBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasPangleBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
            Yodo1MasPangleBannerAdapter.this.callbackAdapterState();
            Yodo1MasPangleBannerAdapter.this.nativeExpressAd.setSlideIntervalTime(30000);
            Yodo1MasPangleBannerAdapter.this.bindAdListener(Yodo1MasPangleBannerAdapter.this.nativeExpressAd);
            Yodo1MasPangleBannerAdapter.this.nativeExpressAd.render();
        }
    };

    public Yodo1MasPangleBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    public boolean isBannerAdvertLoaded() {
        return this.bannerView != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (this.relateAdapter == null || !this.relateAdapter.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (adId != null && adId.object != null && !this.isPriceValuable(adId)) {
            this.handlePricyNotAbaliable();
            return;
        }
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && !adId.adId.equals(this.currentBannerId)) {
            this.currentBannerId = adId.adId;
            AdSlot adSlot = new AdSlot.Builder().setCodeId(adId.adId).setSupportDeepLink(true).setAdCount(1).setExpressViewAcceptedSize(320.0f, 50.0f).build();
            if (this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
                String message = "method: loadBannerAdvert, loading banner ad...";
                Log.d((String)this.TAG, (String)message);
                TTAdNative ttAdNative = this.getTTAdNative();
                if (ttAdNative != null) {
                    this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
                    this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADING;
                    ttAdNative.loadBannerExpressAd(adSlot, this.nativeExpressAdListener);
                    this.logAdIdInfo(adId);
                }
            }
        }
    }

    private TTAdNative getTTAdNative() {
        if (this.relateAdapter != null && this.relateAdapter instanceof Yodo1MasPangleAdapter) {
            Yodo1MasPangleAdapter adapter = (Yodo1MasPangleAdapter)this.relateAdapter;
            return adapter.getTTAdNative();
        }
        return null;
    }

    public View getBannerView() {
        return this.bannerView;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerView != null && destroy) {
            this.bannerView = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return false;
    }

    private void bindAdListener(TTNativeExpressAd nativeExpressAd) {
        nativeExpressAd.setExpressInteractionListener(new TTNativeExpressAd.ExpressAdInteractionListener(){

            public void onAdClicked(View bannerView, int type) {
                String message = "method: onAdClicked, banner: type: " + type;
                Log.d((String)Yodo1MasPangleBannerAdapter.this.TAG, (String)message);
            }

            public void onAdShow(View bannerView, int type) {
                String message = "method: onLoggingImpression, banner: ";
                Log.d((String)Yodo1MasPangleBannerAdapter.this.TAG, (String)message);
                Yodo1MasPangleBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                Yodo1MasPangleBannerAdapter.this.callback(1001, Yodo1MasPangleBannerAdapter.this.TAG + ":{" + message + "}");
            }

            public void onRenderFail(View bannerView, String msg, int code) {
                String message = "method: onRenderFail, banner: msg: " + msg + ", code: " + code;
                Log.d((String)Yodo1MasPangleBannerAdapter.this.TAG, (String)message);
            }

            public void onRenderSuccess(View bannerView, float width, float height) {
                String message = "method: onRenderFail, banner: width: " + width + ", height: " + height;
                Log.d((String)Yodo1MasPangleBannerAdapter.this.TAG, (String)message);
                Yodo1MasPangleBannerAdapter.this.bannerView = bannerView;
            }
        });
        nativeExpressAd.setDislikeCallback(this.getCurrentActivity(), new TTAdDislike.DislikeInteractionCallback(){

            public void onSelected(int position, String value) {
                String message = "method: onSelected, banner: position: " + position + ", value: " + value;
                Log.d((String)Yodo1MasPangleBannerAdapter.this.TAG, (String)message);
                Yodo1MasPangleBannerAdapter.this.dismissBannerAdvert(false);
            }

            public void onCancel() {
                String message = "method: onCancel, banner: ";
                Log.d((String)Yodo1MasPangleBannerAdapter.this.TAG, (String)message);
            }

            public void onRefuse() {
                String message = "method: onRefuse, banner: ";
                Log.d((String)Yodo1MasPangleBannerAdapter.this.TAG, (String)message);
            }
        });
    }
}

