/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.pangle;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTRewardVideoAd;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import java.util.List;

public class Yodo1MasPangleRewardAdapter
extends Yodo1MasRewardAdapterBase {
    protected TTAdNative adNative;
    private TTRewardVideoAd rewardAd;
    private final TTAdNative.RewardVideoAdListener rewardAdLister = new TTAdNative.RewardVideoAdListener(){

        public void onRewardVideoAdLoad(TTRewardVideoAd ad) {
            Log.d((String)Yodo1MasPangleRewardAdapter.this.TAG, (String)"RewardVideoAd onRewardVideoAdLoad");
            Yodo1MasPangleRewardAdapter.this.rewardAd = ad;
            Yodo1MasPangleRewardAdapter.this.rewardAd.setRewardAdInteractionListener(Yodo1MasPangleRewardAdapter.this.eventsListener);
            Yodo1MasPangleRewardAdapter.this.callbackLoad();
        }

        public void onError(int code, String message) {
            String msg = "method: onError, code: " + code + ", message: " + message;
            Log.d((String)Yodo1MasPangleRewardAdapter.this.TAG, (String)msg);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasPangleRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasPangleRewardAdapter.this.callbackError(error, code, message);
        }

        public void onRewardVideoCached() {
            String message = "method: onLoad, reward: onRewardVideoCached";
            Log.d((String)Yodo1MasPangleRewardAdapter.this.TAG, (String)message);
        }
    };
    private final TTRewardVideoAd.RewardAdInteractionListener eventsListener = new TTRewardVideoAd.RewardAdInteractionListener(){

        public void onAdShow() {
            String message = "method: onAdDisplayed";
            Log.d((String)Yodo1MasPangleRewardAdapter.this.TAG, (String)message);
            Yodo1MasPangleRewardAdapter.this.callbackOpen();
        }

        public void onAdClose() {
            String message = "method: onAdClose";
            Log.d((String)Yodo1MasPangleRewardAdapter.this.TAG, (String)message);
            Yodo1MasPangleRewardAdapter.this.callbackClose();
        }

        public void onAdVideoBarClick() {
            String message = "method: onAdVideoBarClick ";
            Log.d((String)Yodo1MasPangleRewardAdapter.this.TAG, (String)message);
            Yodo1MasPangleRewardAdapter.this.callbackClick();
        }

        public void onVideoComplete() {
            String message = "method: onVideoComplete";
            Log.d((String)Yodo1MasPangleRewardAdapter.this.TAG, (String)message);
        }

        public void onVideoError() {
            String message = "method: onVideoError";
            Log.d((String)Yodo1MasPangleRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasPangleRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasPangleRewardAdapter.this.callbackError(error, 0, "");
        }

        public void onRewardVerify(boolean rewardVerify, int rewardAmount, String rewardName, int errorCode, String errorMsg) {
            String message = "RewardVideoAd onRewardVerify, rewardVerify: " + rewardVerify + ", rewardAmount:" + rewardAmount + ", rewardName:" + rewardName + ", errorCode:" + errorCode + ", errorMsg:" + errorMsg;
            Log.d((String)Yodo1MasPangleRewardAdapter.this.TAG, (String)message);
            Yodo1MasPangleRewardAdapter.this.callbackEarned();
        }

        public void onSkippedVideo() {
            Log.d((String)Yodo1MasPangleRewardAdapter.this.TAG, (String)"RewardVideoAd onSkippedVideo");
        }
    };

    public Yodo1MasPangleRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isRewardAdLoaded() {
        return this.rewardAd != null && super.isRewardAdLoaded();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        String adId;
        super.loadRewardAdvert(activity);
        if (this.adNative == null) {
            this.adNative = TTAdSdk.getAdManager().createAdNative((Context)activity);
        }
        if (TextUtils.isEmpty((CharSequence)(adId = this.getAdUnitId(false)))) {
            return;
        }
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Log.d((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        AdSlot adSlot = new AdSlot.Builder().setCodeId(adId).setSupportDeepLink(true).setImageAcceptedSize(1080, 1920).build();
        this.adNative.loadRewardVideoAd(adSlot, this.rewardAdLister);
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardAd.showRewardVideoAd(activity);
        }
    }
}

