package com.yodo1.mas.mediation.pangle;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;

import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTFullScreenVideoAd;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasPangleInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private TTAdNative adNative;
    private TTFullScreenVideoAd interstitialAd;

    public Yodo1MasPangleInterstitialAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && super.isInterstitialAdLoaded();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (adNative == null) adNative = TTAdSdk.getAdManager().createAdNative(activity);

        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Log.d(TAG, message);
        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        // 判断Android当前的屏幕是横屏还是竖屏。横竖屏判断
//        int orientation;
//        if (activity.getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT) {
//            orientation = TTAdConstant.VERTICAL;
//        } else {
//            orientation = TTAdConstant.HORIZONTAL;
//        }
        //Orientation必填参数，期望视频的播放方向：TTAdConstant.HORIZONTAL 或 TTAdConstant.VERTICAL
        AdSlot adSlot = new AdSlot.Builder()
                .setCodeId(adId)
                .setSupportDeepLink(true)
                .setImageAcceptedSize(1080, 1920)
//                .setOrientation(orientation)
                .build();

        //调用插屏广告异步请求接口
        adNative.loadFullScreenVideoAd(adSlot, interstitialListener);
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d(TAG, message);
            interstitialAd.showFullScreenVideoAd(activity);
        }
    }

    private final TTAdNative.FullScreenVideoAdListener interstitialListener = new TTAdNative.FullScreenVideoAdListener() {

        @Override
        public void onFullScreenVideoAdLoad(TTFullScreenVideoAd ad) {
            Log.d(TAG, "FullScreenVideoAd onFullScreenVideoAdLoad");

            interstitialAd = ad;
            interstitialAd.setFullScreenVideoAdInteractionListener(eventsListener);
            callbackLoad();
        }

        @Override
        public void onError(int code, String message) {
            String msg = "method: onError, code: " + code + ", message: " + message;
            Log.d(TAG, msg);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, code, message);
        }

        @Override
        public void onFullScreenVideoCached() {
            String message = "method: FullScreenVideoAd";
            Log.d(TAG, message);
        }
    };

    private final TTFullScreenVideoAd.FullScreenVideoAdInteractionListener eventsListener = new TTFullScreenVideoAd.FullScreenVideoAdInteractionListener() {

        @Override
        public void onAdShow() {
            String message = "method:FullScreenVideoAd onAdShow: ";
            Log.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdClose() {
            String message = "method: FullScreenVideoAd, onAdClose: ";
            Log.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdVideoBarClick() {
            String message = "method: FullScreenVideoAd onAdVideoBarClick: ";
            Log.d(TAG, message);
            callbackClick();
        }

        @Override
        public void onVideoComplete() {
            String message = "method: FullScreenVideoAd onVideoComplete: ";
            Log.d(TAG, message);
        }

        @Override
        public void onSkippedVideo() {
            String message = "method: FullScreenVideoAd onSkippedVideo: ";
            Log.d(TAG, message);
        }
    };
}
