package com.yodo1.mas.mediation.pangle;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bytedance.sdk.openadsdk.TTAdConfig;
import com.bytedance.sdk.openadsdk.TTAdConstant;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;
import com.yodo1.mas.utils.Yodo1MasUtils;

public class Yodo1MasPangleAdapter extends Yodo1MasAdapterBase {

    private TTAdNative mTTAdNative;

    @Override
    public String getAdvertCode() {
        return "pangle";
    }

    @Override
    public String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    public TTAdNative getTTAdNative() {
        return mTTAdNative;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (isInitSDK()) {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
            return;
        }

        if (TextUtils.isEmpty(config.appId)) {
            if (callback != null) {
                callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, "config.appId is null"));
            }
            return;
        }

        init = true;
        TTAdSdk.init(activity, buildConfig(activity, config.appId), new TTAdSdk.InitCallback() {
            @Override
            public void success() {
                String message = "method: success";
                Yodo1MasLog.v(TAG, message);
            }

            @Override
            public void fail(int i, String s) {
                String message = "method: fail, i: " + i + ", s: " + s;
                Yodo1MasLog.v(TAG, message);
            }
        });
        mTTAdNative = TTAdSdk.getAdManager().createAdNative(activity);

        updatePrivacy();
        if (callback != null) {
            callback.onAdapterInitSuccessful(getAdvertCode());
        }
    }

    /**
     * Get TTAdConfig
     * useTextureView: 使用TextureView控件播放视频,默认为SurfaceView,当有SurfaceView冲突的场景，可以使用TextureView
     * allowShowPageWhenScreenLock: 是否在锁屏场景支持展示广告落地页
     * debug: 测试阶段打开，可以通过日志排查问题，上线时去除该调用
     * coppa: Fields to indicate whether you are a child or an adult ，0:adult ，1:child
     * setGDPR: Fields to indicate whether you are protected by GDPR,  the value of GDPR : 0 close GDRP Privacy protection ，1: open GDRP Privacy protection
     *
     * @param context Context
     * @param appId   App Id
     * @return TTAdConfig
     */
    private static TTAdConfig buildConfig(Context context, String appId) {
        return new TTAdConfig.Builder()
                .appId(appId)
                .useTextureView(true)
                .appName(Yodo1MasUtils.getAppName(context))
                .titleBarTheme(TTAdConstant.TITLE_BAR_THEME_DARK)
                .allowShowPageWhenScreenLock(true)
                .debug(false)
                .coppa(Yodo1MasHelper.getInstance().isCOPPAAgeRestricted() ? 1 : 0)
                .setGDPR(Yodo1MasHelper.getInstance().isGDPRUserConsent() ? 1 : 0)
                .setCCPA(Yodo1MasHelper.getInstance().isCCPADoNotSell() ? 1 : 0)
                .supportMultiProcess(false)
                .build();
    }


    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
    }

    // Reward
    @Override
    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasPangleRewardAdapter.class;
    }

    // Interstitial
    @Override
    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasPangleInterstitialAdapter.class;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasPangleBannerAdapter.class;
    }

    // Rewarded Interstitial
    @Override
    protected Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    // App Open
    @Override
    protected Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}
