package com.yodo1.mas.mediation.pangle;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTRewardVideoAd;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

import java.util.List;

public class Yodo1MasPangleRewardAdapter extends Yodo1MasRewardAdapterBase {

    private final TTRewardVideoAd.RewardAdInteractionListener eventsListener = new TTRewardVideoAd.RewardAdInteractionListener() {

        @Override
        public void onAdShow() {
            String message = "method: onAdDisplayed";
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdClose() {
            String message = "method: onAdClose";
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdVideoBarClick() {
            String message = "method: onAdVideoBarClick ";
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }

        @Override
        public void onVideoComplete() {
            String message = "method: onVideoComplete";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onVideoError() {
            String message = "method: onVideoError";
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, 0, "");
        }

        @Override
        public void onRewardVerify(boolean rewardVerify, int rewardAmount, String rewardName, int errorCode, String errorMsg) {
            String message = "RewardVideoAd onRewardVerify, rewardVerify: " + rewardVerify + ", rewardAmount:" + rewardAmount + ", rewardName:" + rewardName + ", errorCode:" + errorCode + ", errorMsg:" + errorMsg;
            Yodo1MasLog.d(TAG, message);
            callbackEarned();
        }

        @Override
        public void onSkippedVideo() {
            Yodo1MasLog.d(TAG, "RewardVideoAd onSkippedVideo");
        }
    };
    protected TTAdNative adNative;
    private TTRewardVideoAd rewardAd;
    private final TTAdNative.RewardVideoAdListener rewardAdLister = new TTAdNative.RewardVideoAdListener() {

        @Override
        public void onRewardVideoAdLoad(TTRewardVideoAd ad) {
            Yodo1MasLog.d(TAG, "RewardVideoAd onRewardVideoAdLoad");
            rewardAd = ad;
            rewardAd.setRewardAdInteractionListener(eventsListener);
            callbackLoad();
        }

        @Override
        public void onError(int code, String message) {
            String msg = "method: onError, code: " + code + ", message: " + message;
            Yodo1MasLog.d(TAG, msg);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, code, message);
        }

        @Override
        public void onRewardVideoCached() {
            String message = "method: onLoad, reward: onRewardVideoCached";
            Yodo1MasLog.d(TAG, message);
        }
    };

    public Yodo1MasPangleRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && super.isRewardAdLoaded();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (adNative == null) adNative = TTAdSdk.getAdManager().createAdNative(activity);

        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d(TAG, message);

        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        AdSlot adSlot = new AdSlot.Builder()
                .setCodeId(adId)
                .setSupportDeepLink(true)
                .setImageAcceptedSize(1080, 1920)
                .build();
        adNative.loadRewardVideoAd(adSlot, rewardAdLister);
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d(TAG, message);
            rewardAd.showRewardVideoAd(activity);
        }
    }
}
