package com.yodo1.mas.mediation.unityads;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsShowOptions;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasUnityAdsRewardAdapter extends Yodo1MasRewardAdapterBase {

    private final IUnityAdsLoadListener loadListener = new IUnityAdsLoadListener() {
        @Override
        public void onUnityAdsAdLoaded(String placementId) {
            String message = "method: onUnityAdsAdLoaded, placementId: " + placementId + "}";
            Yodo1MasLog.d(TAG, message);
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, placementId, true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError adError, String adMessage) {
            String msg = "method: onUnityAdsFailedToLoad, placementId: " + placementId + " error: " + adError.toString() + " message: " + adMessage + "}";
            Yodo1MasLog.d(TAG, msg);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + adMessage + "}");
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, placementId, false, getAdLoadDuration(), adError.ordinal() + "", adMessage);
            callbackError(error, adError.ordinal(), adMessage, adRequestResult);
        }
    };
    private final IUnityAdsShowListener showListener = new IUnityAdsShowListener() {
        @Override
        public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError adError, String adMessage) {
            String msg = "method: onUnityAdsShowFailure, placementId: " + placementId + ", error: " + adError.toString() + ", message: " + adMessage + "}";
            Yodo1MasLog.d(TAG, msg);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + msg + "}");
            callbackError(error, adError.ordinal(), adMessage, null);
        }

        @Override
        public void onUnityAdsShowStart(String placementId) {
            String message = "method: onUnityAdsShowStart, placementId: " + placementId + "}";
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
            String message = "method: onUnityAdsShowComplete, placementId: " + placementId + "}";
            Yodo1MasLog.d(TAG, message);

            if (state == UnityAds.UnityAdsShowCompletionState.COMPLETED) {
                String msg = "method: onUnityAdsShowComplete Reward earned, placementId: " + placementId + "}";
                Yodo1MasLog.d(TAG, msg);
                callbackEarned();
            }
            callbackClose();
        }

        @Override
        public void onUnityAdsShowClick(String placementId) {
            String message = "method: onUnityAdsShowClick, placementId: " + placementId + "}";
            Yodo1MasLog.d(TAG, message);
        }
    };

    public Yodo1MasUnityAdsRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isRewardAdLoaded() {
        String adId = getAdUnitId();
        return !TextUtils.isEmpty(adId) && super.isRewardAdLoaded();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d(TAG, message);

        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        UnityAds.load(adId, loadListener);
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d(TAG, message);
            String adId = getAdUnitId();
            UnityAds.show(activity, adId, new UnityAdsShowOptions(), showListener);
        }
    }
}
