/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.unityads;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.List;

public class Yodo1MasUnityAdsBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private final BannerView.IListener bannerListener = new BannerView.Listener(){

        public void onBannerLoaded(BannerView bannerAdView) {
            super.onBannerLoaded(bannerAdView);
            String message = "method: onBannerLoaded";
            Yodo1MasLog.d((String)Yodo1MasUnityAdsBannerAdapter.this.TAG, (String)message);
            Yodo1MasUnityAdsBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasUnityAdsBannerAdapter.this.trackAdRequestSuccessed();
            Yodo1MasUnityAdsBannerAdapter.this.callback(1003, Yodo1MasUnityAdsBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasUnityAdsBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
            Yodo1MasUnityAdsBannerAdapter.this.callbackAdapterState();
        }

        public void onBannerClick(BannerView bannerAdView) {
            super.onBannerClick(bannerAdView);
            String message = "method: onBannerClick";
            Yodo1MasLog.d((String)Yodo1MasUnityAdsBannerAdapter.this.TAG, (String)message);
        }

        public void onBannerFailedToLoad(BannerView bannerAdView, BannerErrorInfo errorInfo) {
            super.onBannerFailedToLoad(bannerAdView, errorInfo);
            String message = "method: onBannerFailedToLoad, error: " + errorInfo.errorMessage + ", code: " + errorInfo.errorCode;
            Yodo1MasLog.d((String)Yodo1MasUnityAdsBannerAdapter.this.TAG, (String)message);
            Yodo1MasUnityAdsBannerAdapter.this.trackAdRequestFailed(errorInfo.errorCode.toString(), errorInfo.errorMessage);
            Yodo1MasUnityAdsBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            if (Yodo1MasUnityAdsBannerAdapter.this.isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasUnityAdsBannerAdapter.this.TAG + ":{" + message + "}");
                Yodo1MasUnityAdsBannerAdapter.this.callback(error);
                Yodo1MasUnityAdsBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
                Yodo1MasUnityAdsBannerAdapter.this.callbackAdapterState();
            } else {
                Yodo1MasUnityAdsBannerAdapter.this.nextBanner();
                Yodo1MasUnityAdsBannerAdapter.this.loadBannerAdvertDelayed();
            }
        }

        public void onBannerLeftApplication(BannerView bannerView) {
            super.onBannerLeftApplication(bannerView);
            String message = "method: onBannerLeftApplication";
            Yodo1MasLog.d((String)Yodo1MasUnityAdsBannerAdapter.this.TAG, (String)message);
        }
    };
    private BannerView bannerAd;

    public Yodo1MasUnityAdsBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    public boolean isBannerAdvertLoaded() {
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        return adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && this.bannerAd != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (adId != null && adId.object != null && !this.isPriceValuable(adId)) {
            this.handlePricyNotAbaliable();
            return;
        }
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || this.bannerAd != null && adId.adId.equals(this.bannerAd.getPlacementId()))) {
            this.bannerAd = new BannerView(activity, adId.adId, new UnityBannerSize(320, 50));
            this.bannerAd.setListener(this.bannerListener);
        }
        if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            this.bannerAd.load();
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADING;
            this.logAdIdInfo(adId);
        }
    }

    public View getBannerView() {
        return this.bannerAd;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            this.bannerAd.destroy();
            this.bannerAd = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return true;
    }
}

