package com.yodo1.mas.mediation.unityads;

import android.app.Activity;
import android.text.TextUtils;

import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsShowOptions;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasUnityAdsInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private final IUnityAdsLoadListener loadListener = new IUnityAdsLoadListener() {
        @Override
        public void onUnityAdsAdLoaded(String placementId) {
            String message = "method: onUnityAdsAdLoaded, placementId: " + placementId + "}";
            Yodo1MasLog.d(TAG, message);
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, placementId, true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError adError, String adMessage) {
            String msg = "method: onUnityAdsFailedToLoad, placementId: " + placementId + " error: " + adError.toString() + " message: " + adMessage + "}";
            Yodo1MasLog.d(TAG, msg);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + adMessage + "}");
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, placementId, false, getAdLoadDuration(), adError.ordinal()+"", adMessage);
            callbackError(error, adError.ordinal(), adMessage, adRequestResult);
        }
    };
    private final IUnityAdsShowListener showListener = new IUnityAdsShowListener() {
        @Override
        public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError adError, String adMessage) {
            String msg = "method: onUnityAdsShowFailure, placementId: " + placementId + ", error: " + adError.toString() + ", message: " + adMessage + "}";
            Yodo1MasLog.d(TAG, msg);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + msg + "}");
            callbackError(error, adError.ordinal(), adMessage, null);
        }

        @Override
        public void onUnityAdsShowStart(String placementId) {
            String message = "method: onUnityAdsShowStart, placementId: " + placementId + "}";
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
            String message = "method: onUnityAdsShowComplete, placementId: " + placementId + "}";
            Yodo1MasLog.d(TAG, message);

            callbackClose();
        }

        @Override
        public void onUnityAdsShowClick(String placementId) {
            String message = "method: onUnityAdsShowClick, placementId: " + placementId + "}";
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }
    };

    public Yodo1MasUnityAdsInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        String adId = getAdUnitId();
        return !TextUtils.isEmpty(adId) && super.isInterstitialAdLoaded();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d(TAG, message);

        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        UnityAds.load(adId, loadListener);
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);
            String adId = getAdUnitId();
            UnityAds.show(activity, adId, new UnityAdsShowOptions(), showListener);
        }
    }
}
