/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.unityads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.metadata.MetaData;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.analytics.Yodo1MasSensorHelper;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasBanner;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import org.json.JSONObject;

public class Yodo1MasUnityAdsAdapter
extends Yodo1MasAdapterBase {
    private BannerView bannerAd;
    private final IUnityAdsLoadListener loadListener = new IUnityAdsLoadListener(){

        public void onUnityAdsAdLoaded(String placementId) {
            String message = "method: onUnityAdsAdLoaded, placementId: " + placementId + "}";
            Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)message);
            if (Yodo1MasUnityAdsAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasUnityAdsAdapter)Yodo1MasUnityAdsAdapter.this).getRewardAdId().adId)) {
                Yodo1MasUnityAdsAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.SUCCESS);
            } else if (Yodo1MasUnityAdsAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasUnityAdsAdapter)Yodo1MasUnityAdsAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasUnityAdsAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.SUCCESS);
            }
        }

        public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError error, String message) {
            String msg = "method: onUnityAdsFailedToLoad, placementId: " + placementId + " error: " + error.toString() + " message: " + message + "}";
            Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)msg);
            Yodo1MasError yodo1MasError = new Yodo1MasError(-600202, Yodo1MasUnityAdsAdapter.this.TAG + ":{" + message + "}");
            if (Yodo1MasUnityAdsAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasUnityAdsAdapter)Yodo1MasUnityAdsAdapter.this).getRewardAdId().adId)) {
                Yodo1MasUnityAdsAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.FAIL);
                Yodo1MasUnityAdsAdapter.this.callback(yodo1MasError, Yodo1Mas.AdType.Reward);
                Yodo1MasUnityAdsAdapter.this.nextReward();
                Yodo1MasUnityAdsAdapter.this.loadRewardAdvertDelayed();
            } else if (Yodo1MasUnityAdsAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasUnityAdsAdapter)Yodo1MasUnityAdsAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasUnityAdsAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.FAIL);
                Yodo1MasUnityAdsAdapter.this.callback(yodo1MasError, Yodo1Mas.AdType.Interstitial);
                Yodo1MasUnityAdsAdapter.this.nextInterstitial();
                Yodo1MasUnityAdsAdapter.this.loadInterstitialAdvertDelayed();
            }
        }
    };
    private final IUnityAdsListener adsListener = new IUnityAdsListener(){

        public void onUnityAdsReady(String placementId) {
            String message = "method: onUnityAdsStart, placementId: " + placementId + "}";
            Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)message);
        }

        public void onUnityAdsStart(String placementId) {
            String message = "method: onUnityAdsReady, placementId: " + placementId + "}";
            Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)message);
            if (Yodo1MasUnityAdsAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasUnityAdsAdapter)Yodo1MasUnityAdsAdapter.this).getRewardAdId().adId)) {
                Yodo1MasUnityAdsAdapter.this.callback(1001, Yodo1Mas.AdType.Reward, Yodo1MasUnityAdsAdapter.this.TAG + ":{" + message + "}");
            } else if (Yodo1MasUnityAdsAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasUnityAdsAdapter)Yodo1MasUnityAdsAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasUnityAdsAdapter.this.callback(1001, Yodo1Mas.AdType.Interstitial, message);
            }
        }

        public void onUnityAdsFinish(String placementId, UnityAds.FinishState result) {
            String message = "method: onUnityAdsFinish, placementId: " + placementId;
            Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)message);
            if (Yodo1MasUnityAdsAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasUnityAdsAdapter)Yodo1MasUnityAdsAdapter.this).getRewardAdId().adId)) {
                Yodo1MasUnityAdsAdapter.this.callback(1002, Yodo1Mas.AdType.Reward, Yodo1MasUnityAdsAdapter.this.TAG + ":{" + message + "}");
                Yodo1MasUnityAdsAdapter.this.callback(2001, Yodo1Mas.AdType.Reward, Yodo1MasUnityAdsAdapter.this.TAG + ":{" + message + "}");
                Yodo1MasUnityAdsAdapter.this.loadRewardAdvert();
            } else if (Yodo1MasUnityAdsAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasUnityAdsAdapter)Yodo1MasUnityAdsAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasUnityAdsAdapter.this.callback(1002, Yodo1Mas.AdType.Interstitial, message);
                Yodo1MasUnityAdsAdapter.this.loadInterstitialAdvert();
            }
        }

        public void onUnityAdsError(UnityAds.UnityAdsError adError, String adMessage) {
            String message = "method: onUnityAdsError, error: " + adError + ", message: " + adMessage;
            Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasUnityAdsAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasUnityAdsAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
            Yodo1MasUnityAdsAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
        }
    };
    private final BannerView.IListener bannerListener = new BannerView.Listener(){

        public void onBannerLoaded(BannerView bannerAdView) {
            super.onBannerLoaded(bannerAdView);
            String message = "method: onBannerLoaded";
            Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)message);
            Yodo1MasUnityAdsAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasUnityAdsAdapter.this.trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.SUCCESS);
            Yodo1MasUnityAdsAdapter.this.callback(1003, Yodo1Mas.AdType.Banner, Yodo1MasUnityAdsAdapter.this.TAG + ":{" + message + "}");
        }

        public void onBannerClick(BannerView bannerAdView) {
            super.onBannerClick(bannerAdView);
            String message = "method: onBannerClick";
            Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)message);
        }

        public void onBannerFailedToLoad(BannerView bannerAdView, BannerErrorInfo errorInfo) {
            super.onBannerFailedToLoad(bannerAdView, errorInfo);
            String message = "method: onBannerFailedToLoad, error: " + errorInfo.errorMessage + ", code: " + errorInfo.errorCode;
            Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)message);
            Yodo1MasUnityAdsAdapter.this.trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.FAIL);
            Yodo1MasUnityAdsAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasUnityAdsAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasUnityAdsAdapter.this.callback(error, Yodo1Mas.AdType.Banner);
            Yodo1MasUnityAdsAdapter.this.nextBanner();
            Yodo1MasUnityAdsAdapter.this.loadBannerAdvertDelayed();
        }

        public void onBannerLeftApplication(BannerView bannerView) {
            super.onBannerLeftApplication(bannerView);
            String message = "method: onBannerLeftApplication";
            Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)message);
        }
    };

    public String getAdvertCode() {
        return "unity";
    }

    public String getSDKVersion() {
        return "3.7.2";
    }

    public String getMediationVersion() {
        return "4.3.0";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, final @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            UnityAds.removeListener((IUnityAdsListener)this.adsListener);
            UnityAds.addListener((IUnityAdsListener)this.adsListener);
            if (!UnityAds.isInitialized()) {
                if (!TextUtils.isEmpty((CharSequence)config.appId)) {
                    UnityAds.initialize((Context)activity.getApplicationContext(), (String)config.appId, (boolean)Yodo1MasHelper.getInstance().isDebug(), (IUnityAdsInitializationListener)new IUnityAdsInitializationListener(){

                        public void onInitializationComplete() {
                            String message = "method: onInitializationComplete, init successful";
                            Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)message);
                            Yodo1MasUnityAdsAdapter.this.updatePrivacy();
                            Yodo1MasUnityAdsAdapter.this.loadRewardAdvert();
                            Yodo1MasUnityAdsAdapter.this.loadInterstitialAdvert();
                            Yodo1MasUnityAdsAdapter.this.loadBannerAdvert();
                            if (callback != null) {
                                callback.onAdapterInitSuccessful(Yodo1MasUnityAdsAdapter.this.getAdvertCode());
                            }
                        }

                        public void onInitializationFailed(UnityAds.UnityAdsInitializationError adError, String adMessage) {
                            String message = "method: onInitializationFailed, error: " + adError + ", message:" + adMessage;
                            Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)message);
                            if (callback != null) {
                                callback.onAdapterInitFailed(Yodo1MasUnityAdsAdapter.this.getAdvertCode(), new Yodo1MasError(-600001, message));
                            }
                        }
                    });
                } else if (callback != null) {
                    callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
                }
            }
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public boolean isInitSDK() {
        return super.isInitSDK() && UnityAds.isInitialized();
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        Yodo1MasUnityAdsAdapter.setUnityAdsPrivacy(this.currentActivity);
    }

    public static void setUnityAdsPrivacy(Activity activity) {
        if (activity == null) {
            return;
        }
        MetaData data = new MetaData((Context)activity);
        data.set("gdpr.consent", (Object)Yodo1MasHelper.getInstance().isGDPRUserConsent());
        data.set("privacy.useroveragelimit", (Object)(!Yodo1MasHelper.getInstance().isCOPPAAgeRestricted() ? 1 : 0));
        data.set("privacy.consent", (Object)(!Yodo1MasHelper.getInstance().isCCPADoNotSell() ? 1 : 0));
        data.commit();
    }

    public boolean isRewardAdvertLoaded() {
        super.isRewardAdvertLoaded();
        Yodo1MasAdapterBase.AdId adId = this.getRewardAdId();
        return adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && UnityAds.isReady((String)adId.adId);
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getRewardAdId();
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId)) {
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d((String)this.TAG, (String)message);
            UnityAds.load((String)adId.adId, (IUnityAdsLoadListener)this.loadListener);
        }
    }

    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            UnityAds.show((Activity)activity, (String)this.getRewardAdId().adId);
        }
    }

    public boolean isInterstitialAdvertLoaded() {
        super.isInterstitialAdvertLoaded();
        Yodo1MasAdapterBase.AdId adId = this.getInterstitialAdId();
        return adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && UnityAds.isReady((String)adId.adId);
    }

    public void loadInterstitialAdvert(@NonNull Activity activity) {
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getInterstitialAdId();
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId)) {
            String message = "method: loadInterstitialAdvert, loading interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            UnityAds.load((String)adId.adId, (IUnityAdsLoadListener)this.loadListener);
        }
    }

    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            UnityAds.show((Activity)activity, (String)this.getInterstitialAdId().adId);
        }
    }

    public boolean isBannerAdvertLoaded() {
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        return adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && this.bannerAd != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || this.bannerAd != null && adId.adId.equals(this.bannerAd.getPlacementId()))) {
            this.bannerAd = new BannerView(activity, adId.adId, new UnityBannerSize(320, 50));
            this.bannerAd.setListener(this.bannerListener);
        }
        if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Log.d((String)this.TAG, (String)message);
            this.bannerAd.load();
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showBannerAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showBannerAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Banner, callback)) {
            String message = "method: showBannerAdvert, show banner ad...";
            Log.d((String)this.TAG, (String)message);
            Yodo1MasBanner.showBanner((Activity)activity, (View)this.bannerAd, (JSONObject)object);
            this.callback(1001, Yodo1Mas.AdType.Banner, message);
        }
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null) {
            Yodo1MasBanner.removeBanner((View)this.bannerAd);
            if (destroy) {
                this.bannerAd.destroy();
                this.bannerAd = null;
                this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                this.loadBannerAdvert();
            }
        }
    }
}

