/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.unityads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.metadata.MetaData;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.unityads.Yodo1MasUnityAdsBannerAdapter;
import com.yodo1.mas.mediation.unityads.Yodo1MasUnityAdsInterstitialAdapter;
import com.yodo1.mas.mediation.unityads.Yodo1MasUnityAdsRewardAdapter;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

public class Yodo1MasUnityAdsAdapter
extends Yodo1MasAdapterBase {
    public static void setUnityAdsPrivacy(@NonNull Activity activity) {
        MetaData data = new MetaData((Context)activity);
        data.set("gdpr.consent", (Object)Yodo1MasHelper.getInstance().isGDPRUserConsent());
        data.set("privacy.useroveragelimit", (Object)(!Yodo1MasHelper.getInstance().isCOPPAAgeRestricted() ? 1 : 0));
        data.set("privacy.consent", (Object)(!Yodo1MasHelper.getInstance().isCCPADoNotSell() ? 1 : 0));
        data.set("privacy.mode", (Object)"mixed");
        data.set("user.nonbehavioral", (Object)Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
        data.commit();
    }

    public String getAdvertCode() {
        return "unity";
    }

    public String getSDKVersion() {
        return "4.2.1";
    }

    public String getMediationVersion() {
        return "4.7.1";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, final @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (TextUtils.isEmpty((CharSequence)config.appId)) {
            if (callback != null) {
                callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
            }
            return;
        }
        if (!this.isInitSDK()) {
            this.init = true;
            if (!UnityAds.isInitialized()) {
                this.updatePrivacy();
                UnityAds.initialize((Context)activity.getApplicationContext(), (String)config.appId, (boolean)Yodo1MasHelper.getInstance().isDebug(), (IUnityAdsInitializationListener)new IUnityAdsInitializationListener(){

                    public void onInitializationComplete() {
                        String message = "method: onInitializationComplete, init successful";
                        Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)message);
                        if (callback != null) {
                            callback.onAdapterInitSuccessful(Yodo1MasUnityAdsAdapter.this.getAdvertCode());
                        }
                    }

                    public void onInitializationFailed(UnityAds.UnityAdsInitializationError adError, String adMessage) {
                        String message = "method: onInitializationFailed, error: " + adError + ", message:" + adMessage;
                        Log.d((String)Yodo1MasUnityAdsAdapter.this.TAG, (String)message);
                        if (callback != null) {
                            callback.onAdapterInitFailed(Yodo1MasUnityAdsAdapter.this.getAdvertCode(), new Yodo1MasError(-600001, message));
                        }
                    }
                });
            }
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public boolean isInitSDK() {
        return super.isInitSDK() && UnityAds.isInitialized();
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        Yodo1MasUnityAdsAdapter.setUnityAdsPrivacy(this.currentActivity);
    }

    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasUnityAdsRewardAdapter.class;
    }

    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasUnityAdsInterstitialAdapter.class;
    }

    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasUnityAdsBannerAdapter.class;
    }
}

