package com.yodo1.mas.mediation.unityads;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;

import androidx.annotation.NonNull;

import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;

import java.util.List;

public class Yodo1MasUnityAdsBannerAdapter extends Yodo1MasBannerAdapterBase {

    private final BannerView.IListener bannerListener = new BannerView.Listener() {
        @Override
        public void onBannerLoaded(BannerView bannerAdView) {
            super.onBannerLoaded(bannerAdView);
            String message = "method: onBannerLoaded";
            Log.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            trackAdRequestSuccessed();
            callback(Yodo1MasAdEvent.CODE_LOADED, TAG + ":{" + message + "}");

            advertAdapterState = AdvertAdapterState.LOADED;
            callbackAdapterState();
        }

        @Override
        public void onBannerClick(BannerView bannerAdView) {
            super.onBannerClick(bannerAdView);
            String message = "method: onBannerClick";
            Log.d(TAG, message);
        }

        @Override
        public void onBannerFailedToLoad(BannerView bannerAdView, BannerErrorInfo errorInfo) {
            super.onBannerFailedToLoad(bannerAdView, errorInfo);
            String message = "method: onBannerFailedToLoad, error: " + errorInfo.errorMessage + ", code: " + errorInfo.errorCode;
            Log.d(TAG, message);
            trackAdRequestFailed(errorInfo.errorCode.toString(), errorInfo.errorMessage);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;

            if (isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
                callback(error);
                advertAdapterState = AdvertAdapterState.FAILED;
                callbackAdapterState();
            } else {
                nextBanner();
                loadBannerAdvertDelayed();
            }
        }

        @Override
        public void onBannerLeftApplication(BannerView bannerView) {
            super.onBannerLeftApplication(bannerView);
            String message = "method: onBannerLeftApplication";
            Log.d(TAG, message);
        }
    };

    private BannerView bannerAd;

    public Yodo1MasUnityAdsBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    @Override
    public boolean isBannerAdvertLoaded() {
        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        return adId != null && !TextUtils.isEmpty(adId.adId) && bannerAd != null && bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        if (adId != null && adId.object != null && !isPriceValuable(adId)) {
            handlePricyNotAbaliable();
            return;
        }

        if (adId != null && !TextUtils.isEmpty(adId.adId) && (bannerAd == null || !adId.adId.equals(bannerAd.getPlacementId()))) {
            bannerAd = new BannerView(activity, adId.adId, new UnityBannerSize(320, 50));
            bannerAd.setListener(bannerListener);
        }
        if (bannerAd != null && bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Log.d(TAG, message);
            bannerAd.load();
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            advertAdapterState = AdvertAdapterState.LOADING;
            logAdIdInfo(adId);
        }
    }

    @Override
    public View getBannerView() {
        return bannerAd;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                bannerAd.destroy();
                bannerAd = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                advertAdapterState = AdvertAdapterState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return true;
    }
}
