/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.unityads;

import android.app.Activity;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsShowOptions;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import java.util.List;

public class Yodo1MasUnityAdsRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private final IUnityAdsLoadListener loadListener = new IUnityAdsLoadListener(){

        public void onUnityAdsAdLoaded(String placementId) {
            String message = "method: onUnityAdsAdLoaded, placementId: " + placementId + "}";
            Yodo1MasLog.v((String)Yodo1MasUnityAdsRewardAdapter.this.TAG, (String)message);
            Yodo1MasUnityAdsRewardAdapter.this.callbackLoad();
        }

        public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError adError, String adMessage) {
            String msg = "method: onUnityAdsFailedToLoad, placementId: " + placementId + " error: " + adError.toString() + " message: " + adMessage + "}";
            Yodo1MasLog.v((String)Yodo1MasUnityAdsRewardAdapter.this.TAG, (String)msg);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasUnityAdsRewardAdapter.this.TAG + ":{" + adMessage + "}");
            Yodo1MasUnityAdsRewardAdapter.this.callbackError(error, adError.ordinal(), adMessage);
        }
    };
    private final IUnityAdsShowListener showListener = new IUnityAdsShowListener(){

        public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError adError, String adMessage) {
            String msg = "method: onUnityAdsShowFailure, placementId: " + placementId + ", error: " + adError.toString() + ", message: " + adMessage + "}";
            Yodo1MasLog.v((String)Yodo1MasUnityAdsRewardAdapter.this.TAG, (String)msg);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasUnityAdsRewardAdapter.this.TAG + ":{" + msg + "}");
            Yodo1MasUnityAdsRewardAdapter.this.callbackError(error, adError.ordinal(), adMessage);
        }

        public void onUnityAdsShowStart(String placementId) {
            String message = "method: onUnityAdsShowStart, placementId: " + placementId + "}";
            Yodo1MasLog.v((String)Yodo1MasUnityAdsRewardAdapter.this.TAG, (String)message);
            Yodo1MasUnityAdsRewardAdapter.this.callbackOpen();
        }

        public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
            String message = "method: onUnityAdsShowComplete, placementId: " + placementId + "}";
            Yodo1MasLog.v((String)Yodo1MasUnityAdsRewardAdapter.this.TAG, (String)message);
            if (state == UnityAds.UnityAdsShowCompletionState.COMPLETED) {
                Yodo1MasUnityAdsRewardAdapter.this.callbackEarned();
            }
            Yodo1MasUnityAdsRewardAdapter.this.callbackClose();
        }

        public void onUnityAdsShowClick(String placementId) {
            String message = "method: onUnityAdsShowClick, placementId: " + placementId + "}";
            Yodo1MasLog.v((String)Yodo1MasUnityAdsRewardAdapter.this.TAG, (String)message);
        }
    };

    public Yodo1MasUnityAdsRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isRewardAdLoaded() {
        String adId = this.getAdUnitId(false);
        return !TextUtils.isEmpty((CharSequence)adId) && super.isRewardAdLoaded();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.v((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        UnityAds.load((String)adId, (IUnityAdsLoadListener)this.loadListener);
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.v((String)this.TAG, (String)message);
            String adId = this.getAdUnitId(false);
            UnityAds.show((Activity)activity, (String)adId, (UnityAdsShowOptions)new UnityAdsShowOptions(), (IUnityAdsShowListener)this.showListener);
        }
    }
}

