package com.yodo1.mas.mediation.unityads;

import android.app.Activity;
import android.text.TextUtils;

import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsShowOptions;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasUnityAdsInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private final IUnityAdsLoadListener loadListener = new IUnityAdsLoadListener() {
        @Override
        public void onUnityAdsAdLoaded(String placementId) {
            String message = "method: onUnityAdsAdLoaded, placementId: " + placementId + "}";
            Yodo1MasLog.v(TAG, message);
            callbackLoad();
        }

        @Override
        public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError adError, String adMessage) {
            String msg = "method: onUnityAdsFailedToLoad, placementId: " + placementId + " error: " + adError.toString() + " message: " + adMessage + "}";
            Yodo1MasLog.v(TAG, msg);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + adMessage + "}");
            callbackError(error, adError.ordinal(), adMessage);
        }
    };
    private final IUnityAdsShowListener showListener = new IUnityAdsShowListener() {
        @Override
        public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError adError, String adMessage) {
            String msg = "method: onUnityAdsShowFailure, placementId: " + placementId + ", error: " + adError.toString() + ", message: " + adMessage + "}";
            Yodo1MasLog.v(TAG, msg);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + msg + "}");
            callbackError(error, adError.ordinal(), adMessage);
        }

        @Override
        public void onUnityAdsShowStart(String placementId) {
            String message = "method: onUnityAdsShowStart, placementId: " + placementId + "}";
            Yodo1MasLog.v(TAG, message);
            callbackOpen();
        }

        @Override
        public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
            String message = "method: onUnityAdsShowComplete, placementId: " + placementId + "}";
            Yodo1MasLog.v(TAG, message);

            callbackClose();
        }

        @Override
        public void onUnityAdsShowClick(String placementId) {
            String message = "method: onUnityAdsShowClick, placementId: " + placementId + "}";
            Yodo1MasLog.v(TAG, message);
            callbackClick();
        }
    };

    public Yodo1MasUnityAdsInterstitialAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        String adId = getAdUnitId(false);
        return !TextUtils.isEmpty(adId) && super.isInterstitialAdLoaded();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.v(TAG, message);

        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        UnityAds.load(adId, loadListener);
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.v(TAG, message);
            String adId = getAdUnitId(false);
            UnityAds.show(activity, adId, new UnityAdsShowOptions(), showListener);
        }
    }
}
