package com.yodo1.mas.mediation.unityads;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.metadata.MetaData;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasUnityAdsAdapter extends Yodo1MasAdapterBase {

    /**
     * Set UnityAds's privacy
     * About UnityAds's privacy, please see this link https://docs.unity3d.com/Packages/com.unity.ads@3.6/manual/LegalDataPrivacy.html?q=useroveragelimit
     *
     * @param activity Activity
     */
    public static void setUnityAdsPrivacy(@NonNull Activity activity) {

        MetaData data = new MetaData(activity);
        data.set("gdpr.consent", Yodo1MasHelper.getInstance().isGDPRUserConsent());
        /**
         * // If the user is over the specified age limit:
         * MetaData ageGateMetaData = new MetaData(this);
         * ageGateMetaData.set("privacy.useroveragelimit", true);
         * ageGateMetaData.commit();
         *
         * // If the user is under the specified age limit:
         * MetaData ageGateMetaData = new MetaData(this);
         * ageGateMetaData.set("privacy.useroveragelimit", false);
         * ageGateMetaData.commit();
         */
        data.set("privacy.useroveragelimit", !Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
        /**
         * // If the user opts in to targeted advertising:
         * MetaData privacyMetaData = new MetaData(this);
         * privacyMetaData.set("privacy.consent", true);
         * privacyMetaData.commit();
         *
         * // If the user opts out of targeted advertising:
         * MetaData privacyMetaData = new MetaData(this);
         * privacyMetaData.set("privacy.consent", false);
         * privacyMetaData.commit();
         */
        data.set("privacy.consent", !Yodo1MasHelper.getInstance().isCCPADoNotSell());

        /**
         * Google Play Families compliance, you can find out details from the below link
         * https://docs.unity.com/ads/GoogleFamiliesCompliance.html?utm_campaign=Other_global_Transactional_2022-03-dg-operate-unity-ads-GoogleFamiliesPolicyUpdate-campaign&utm_content=2022-03-dg-operate-unity-ads-GoogleFamiliesPolicyUpdate&utm_medium=email&utm_source=Eloqua#AndroidCode
         */
        // This is a mixed audience game.
        data.set("privacy.mode", "mixed");
        // true If the user opts out of personalized ads
        // false If the user opts in to personalized ads
        data.set("user.nonbehavioral", Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());

        data.commit();
    }

    @Override
    public String getAdvertCode() {
        return "unity";
    }

    @Override
    public String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (TextUtils.isEmpty(config.appId)) {
            if (callback != null) {
                callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, "config.appId is null"));
            }
            return;
        }

        if (!isInitSDK()) {
            init = true;
            if (!UnityAds.isInitialized()) {
                updatePrivacy();
                UnityAds.initialize(activity.getApplicationContext(), config.appId, Yodo1MasHelper.getInstance().isDebug(), new IUnityAdsInitializationListener() {
                    @Override
                    public void onInitializationComplete() {
                        String message = "method: onInitializationComplete, init successful";
                        Yodo1MasLog.v(TAG, message);
                        if (callback != null) {
                            callback.onAdapterInitSuccessful(getAdvertCode());
                        }
                    }

                    @Override
                    public void onInitializationFailed(UnityAds.UnityAdsInitializationError adError, String adMessage) {
                        String message = "method: onInitializationFailed, error: " + adError + ", message:" + adMessage;
                        Yodo1MasLog.v(TAG, message);
                        if (callback != null) {
                            callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, message));
                        }
                    }
                });
            }
        } else {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
        }
    }

    @Override
    public boolean isInitSDK() {
        return super.isInitSDK() && UnityAds.isInitialized();
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        setUnityAdsPrivacy(currentActivity);
    }

    // Reward
    @Override
    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasUnityAdsRewardAdapter.class;
    }

    // Interstitial
    @Override
    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasUnityAdsInterstitialAdapter.class;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasUnityAdsBannerAdapter.class;
    }

    // Rewarded Interstitial
    @Override
    protected Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    // App Open
    @Override
    protected Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}
