package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.vungle.ads.InitializationListener;
import com.vungle.ads.VungleAds;
import com.vungle.ads.VungleError;
import com.vungle.ads.VunglePrivacySettings;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasVungleAdapter extends Yodo1MasAdapterBase {

    public static void setVunglePrivacy() {
        VunglePrivacySettings.setGDPRStatus(Yodo1MasHelper.getInstance().isGDPRUserConsent(), "1.0.0");
        VunglePrivacySettings.setCCPAStatus(!Yodo1MasHelper.getInstance().isCCPADoNotSell());
    }

    @Override
    public String getAdvertCode() {
        return "vungle";
    }

    @Override
    public String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!isInitSDK()) {
            init = true;
            if (!VungleAds.isInitialized()) {
                if (!TextUtils.isEmpty(config.appId)) {
                    setVungleCOPPAPrivacy();
                    VungleAds.init(activity.getApplicationContext(), config.appId, new InitializationListener() {
                        @Override
                        public void onSuccess() {
                            String message = "method: onSuccess, init successful";
                            Yodo1MasLog.d(TAG, message);
                            updatePrivacy();
                            if (callback != null) {
                                callback.onAdapterInitSuccessful(getAdvertCode());
                            }
                        }

                        @Override
                        public void onError(@NonNull VungleError vungleError) {
                            String message = "method: onError, exception: " + vungleError.getErrorMessage();
                            Yodo1MasLog.d(TAG, message);
                            if (callback != null) {
                                callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, message));
                            }
                        }
                    });
                } else {
                    if (callback != null) {
                        callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, "config.appId is null"));
                    }
                }
            }
        } else {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
        }
    }

    @Override
    public boolean isInitSDK() {
        return super.isInitSDK() && VungleAds.isInitialized();
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        setVunglePrivacy();
    }

    /**
     * need call before initialization the Vungle SDK
     */
    private void setVungleCOPPAPrivacy() {
        VunglePrivacySettings.setCOPPAStatus(Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
    }

    // Reward
    @Override
    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasVungleRewardAdapter.class;
    }

    // Interstitial
    @Override
    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasVungleInterstitialAdapter.class;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasVungleBannerAdapter.class;
    }

    // Rewarded Interstitial
    @Override
    protected Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    // App Open
    @Override
    protected Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}
