/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.vungle.ads.AdConfig;
import com.vungle.ads.BaseAd;
import com.vungle.ads.BaseAdListener;
import com.vungle.ads.RewardedAd;
import com.vungle.ads.RewardedAdListener;
import com.vungle.ads.VungleError;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasVungleRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private RewardedAd rewardAd;
    private final RewardedAdListener rewardedAdListener = new RewardedAdListener(){

        public void onAdRewarded(@NonNull BaseAd baseAd) {
            String message = "method: onAdRewarded, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleRewardAdapter.this.TAG, (String)message);
            Yodo1MasVungleRewardAdapter.this.callbackEarned();
        }

        public void onAdLoaded(@NonNull BaseAd baseAd) {
            String message = "method: onAdLoaded, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleRewardAdapter.this.TAG, (String)message);
            Yodo1MasVungleRewardAdapter.this.adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Reward, (String)Yodo1MasVungleRewardAdapter.this.advertCode, (String)baseAd.getPlacementId(), (boolean)true, (long)Yodo1MasVungleRewardAdapter.this.getAdLoadDuration(), null, null);
            Yodo1MasVungleRewardAdapter.this.callbackLoad(Yodo1MasVungleRewardAdapter.this.adRequestResult);
        }

        public void onAdStart(@NonNull BaseAd baseAd) {
            String message = "method: onAdStart, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleRewardAdapter.this.TAG, (String)message);
            Yodo1MasVungleRewardAdapter.this.callbackOpen();
        }

        public void onAdImpression(@NonNull BaseAd baseAd) {
            String message = "method: onAdImpression, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleRewardAdapter.this.TAG, (String)message);
        }

        public void onAdEnd(@NonNull BaseAd baseAd) {
            String message = "method: onAdEnd, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleRewardAdapter.this.TAG, (String)message);
            Yodo1MasVungleRewardAdapter.this.callbackClose();
        }

        public void onAdClicked(@NonNull BaseAd baseAd) {
            String message = "method: onAdClicked, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleRewardAdapter.this.TAG, (String)message);
            Yodo1MasVungleRewardAdapter.this.callbackClick();
        }

        public void onAdLeftApplication(@NonNull BaseAd baseAd) {
            String message = "method: onAdLeftApplication, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleRewardAdapter.this.TAG, (String)message);
        }

        public void onAdFailedToLoad(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            String message = "method: onAdFailedToLoad, placementId: " + baseAd.getPlacementId() + ", exception: " + vungleError.getErrorMessage() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasVungleRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasVungleRewardAdapter.this.adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Reward, (String)Yodo1MasVungleRewardAdapter.this.advertCode, (String)baseAd.getPlacementId(), (boolean)false, (long)Yodo1MasVungleRewardAdapter.this.getAdLoadDuration(), (String)(vungleError.getCode() + ""), (String)vungleError.getErrorMessage());
            Yodo1MasVungleRewardAdapter.this.callbackError(error, vungleError.getCode(), vungleError.getErrorMessage(), Yodo1MasVungleRewardAdapter.this.adRequestResult);
        }

        public void onAdFailedToPlay(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            String message = "method: onAdFailedToPlay, placementId: " + baseAd.getPlacementId() + ", exception: " + vungleError.getErrorMessage() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasVungleRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasVungleRewardAdapter.this.callbackError(error, vungleError.getCode(), vungleError.getErrorMessage(), null);
        }
    };

    public Yodo1MasVungleRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    public boolean isRewardAdLoaded() {
        return this.rewardAd != null && this.rewardAd.canPlayAd() != false;
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = this.getAdUnitId();
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        this.rewardAd = new RewardedAd((Context)activity, adId, new AdConfig());
        this.rewardAd.setAdListener((BaseAdListener)this.rewardedAdListener);
        this.rewardAd.load(null);
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            this.rewardAd.play((Context)activity);
        }
    }
}

