package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.vungle.ads.AdConfig;
import com.vungle.ads.BaseAd;
import com.vungle.ads.InterstitialAd;
import com.vungle.ads.InterstitialAdListener;
import com.vungle.ads.VungleError;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasVungleInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private InterstitialAd interstitialAd;

    private final InterstitialAdListener interstitialAdListener = new InterstitialAdListener() {
        @Override
        public void onAdLoaded(@NonNull BaseAd baseAd) {
            String message = "method: onAdLoaded, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, baseAd.getPlacementId(), true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onAdStart(@NonNull BaseAd baseAd) {
            String message = "method: onAdStart, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdImpression(@NonNull BaseAd baseAd) {
            String message = "method: onAdImpression, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdEnd(@NonNull BaseAd baseAd) {
            String message = "method: onAdEnd, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdClicked(@NonNull BaseAd baseAd) {
            String message = "method: onAdClicked, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }

        @Override
        public void onAdLeftApplication(@NonNull BaseAd baseAd) {
            String message = "method: onAdLeftApplication, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdFailedToLoad(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            String message = "method: onAdFailedToLoad, placementId: " + baseAd.getPlacementId() + ", exception: " + vungleError.getErrorMessage() + "}";
            Yodo1MasLog.d(TAG, message);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, baseAd.getPlacementId(), false, getAdLoadDuration(), vungleError.getCode() + "", vungleError.getErrorMessage());
            callbackError(error, vungleError.getCode(), vungleError.getErrorMessage(), adRequestResult);
        }

        @Override
        public void onAdFailedToPlay(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            String message = "method: onAdFailedToPlay, placementId: " + baseAd.getPlacementId() + ", exception: " + vungleError.getErrorMessage() + "}";
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, vungleError.getCode(), vungleError.getErrorMessage(), null);
        }
    };

    public Yodo1MasVungleInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && interstitialAd.canPlayAd();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d(TAG, message);
        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();

        interstitialAd = new InterstitialAd(activity, adId, new AdConfig());
        interstitialAd.setAdListener(interstitialAdListener);
        interstitialAd.load(null);
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);
            interstitialAd.play(activity);
        }
    }
}
